/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.item.weapons.StaffItem;
import io.redspace.ironsspellbooks.item.weapons.StaffTier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CustomStaff
extends StaffItem {
    private final Builder builder;

    private CustomStaff(Builder builder) {
        super(builder.createItemProperties().attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)builder.tierBuilder.build())));
        this.builder = builder;
    }

    public int getEnchantmentValue() {
        return this.builder.enchantmentValue;
    }

    @ReturnsSelf
    public static class Builder
    extends ItemBuilder {
        private final StaffTierBuilder tierBuilder = new StaffTierBuilder();
        private int enchantmentValue = 20;

        public Builder(ResourceLocation i) {
            super(i);
        }

        public Builder setEnchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        @Info(value="**NOT SUPPORTED**\n")
        public ItemBuilder use(ItemBuilder.UseCallback use) {
            ConsoleJS.STARTUP.warn((Object)"Use callback is not supported for this Staff.");
            return this;
        }

        public Builder setTier(Consumer<StaffTierBuilder> tier) {
            tier.accept(this.tierBuilder);
            return this;
        }

        public StaffItem createObject() {
            return new CustomStaff(this);
        }

        public static class StaffTierBuilder {
            private final List<AttributeContainer> attributes = new ArrayList<AttributeContainer>();
            private StaffTierEnum existingTier = null;
            private boolean mergeAttributes = false;
            private Float damage;
            private Float speed;

            public StaffTierBuilder setDamage(float damage) {
                this.damage = Float.valueOf(damage);
                return this;
            }

            public StaffTierBuilder setSpeed(float speed) {
                this.speed = Float.valueOf(speed);
                return this;
            }

            public StaffTierBuilder addAttribute(Holder<Attribute> attribute, double value, AttributeModifier.Operation operation) {
                this.attributes.add(new AttributeContainer(attribute, value, operation));
                return this;
            }

            public StaffTierBuilder useBaseTier(StaffTierEnum tier, boolean mergeAttributes) {
                this.existingTier = tier;
                this.mergeAttributes = mergeAttributes;
                return this;
            }

            @HideFromJS
            public StaffTier build() {
                if (this.existingTier != null) {
                    if (this.damage == null) {
                        this.damage = Float.valueOf(this.existingTier.getTier().getAttackDamageBonus());
                    }
                    if (this.speed == null) {
                        this.speed = Float.valueOf(this.existingTier.getTier().getSpeed());
                    }
                    if (this.mergeAttributes) {
                        this.attributes.addAll(List.of(this.existingTier.getTier().getAdditionalAttributes()));
                    }
                }
                if (this.damage == null) {
                    this.damage = Float.valueOf(2.0f);
                }
                if (this.speed == null) {
                    this.speed = Float.valueOf(-3.0f);
                }
                return new StaffTier(this.damage.floatValue(), this.speed.floatValue(), this.attributes.toArray(new AttributeContainer[0]));
            }
        }

        public static enum StaffTierEnum {
            GRAYBEARD(StaffTier.GRAYBEARD),
            ARTIFICER(StaffTier.ARTIFICER),
            ICE_STAFF(StaffTier.ICE_STAFF),
            LIGHTNING_ROD(StaffTier.LIGHTNING_ROD),
            BLOOD_STAFF(StaffTier.BLOOD_STAFF);

            private final StaffTier tier;

            private StaffTierEnum(StaffTier tier) {
                this.tier = tier;
            }

            public StaffTier getTier() {
                return this.tier;
            }
        }
    }
}

