/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.spell;

import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public interface AbstractSpellWrapper {
    @Info(value="    Returns a spell registry object.\n")
    @Nullable
    public static AbstractSpell of(ResourceKey<AbstractSpell> spellKey) {
        return (AbstractSpell)SpellRegistry.REGISTRY.get(spellKey);
    }

    public static Holder<AbstractSpell> ofHolder(Holder<AbstractSpell> holder) {
        return holder;
    }

    @Info(value="    Returns whether a spell is registered or not.\n")
    public static boolean exists(ResourceKey<AbstractSpell> spellKey) {
        return SpellRegistry.REGISTRY.containsKey(spellKey);
    }

    @Info(value="    Returns whether an object is a spell or not.\n")
    public static boolean isSpell(Object o) {
        return o instanceof AbstractSpell;
    }

    @Info(value="    Returns either `ENABLED`, `DISABLED`, or `UNREGISTERED`, based on the spell inputted.\n")
    public static SpellStatus checkStatus(ResourceKey<AbstractSpell> spellKey) {
        AbstractSpell spell = AbstractSpellWrapper.of(spellKey);
        return spell == null ? SpellStatus.UNREGISTERED : (spell.isEnabled() ? SpellStatus.ENABLED : SpellStatus.DISABLED);
    }

    @Info(value="    Returns whether a spell is enabled in the config or not.\n")
    public static boolean isEnabled(ResourceKey<AbstractSpell> spellKey) {
        AbstractSpell spell = AbstractSpellWrapper.of(spellKey);
        return spell != null && spell.isEnabled();
    }

    public static enum SpellStatus {
        REGISTERED,
        UNREGISTERED,
        ENABLED,
        DISABLED;

    }
}

