/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DeleteConfirmGroupPopup
extends PopupButtonScreen<Tuple2<Boolean, Boolean>> {
    private boolean deleteWaypoints = false;
    private final boolean nativeGroup;

    protected DeleteConfirmGroupPopup(WaypointGroup group) {
        super((Component)(WaypointGroupStore.isNative(group) ? Component.translatable((String)"jm.waypoint.delete_group_native.title", (Object[])new Object[]{group.getName()}) : Component.translatable((String)"jm.waypoint.delete_group.title", (Object[])new Object[]{group.getName()})));
        this.nativeGroup = WaypointGroupStore.isNative(group);
    }

    protected void init() {
        CheckBox checkbox = new CheckBox(Constants.getString("jm.waypoint.delete_group.confirm.checkbox"), false, button -> this.setDeleteWaypoints(((CheckBox)button).getToggled()));
        checkbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete_group.confirm.checkbox.tooltip", (Object[])new Object[]{WaypointGroupStore.DEFAULT.getName()})));
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        if (!this.nativeGroup) {
            this.layout.addChild((LayoutElement)checkbox);
        } else {
            this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.translatable((String)"jm.waypoint.delete_group_native.purge"), this.font).setMaxWidth(150).setCentered(true));
        }
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(6);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.delete"), b -> this.delete()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void delete() {
        this.setResponseAndClose(new Tuple2((Object)true, (Object)this.deleteWaypoints));
    }

    private void setDeleteWaypoints(boolean deleteWaypoints) {
        this.deleteWaypoints = deleteWaypoints;
    }

    @Override
    protected void onClosed() {
        this.onClose.closed((Tuple2)this.response);
        super.onClose();
    }
}

