/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api;

import dev.xylonity.knightlib.mixin.CameraAccessor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class CameraShakeManager {
    private static final Map<UUID, Shake> SHAKES = new ConcurrentHashMap<UUID, Shake>();

    private CameraShakeManager() {
    }

    public static void shake(Player player, int durationTicks, float intensityX, float intensityY, float intensityZ, int fadeStartTick) {
        SHAKES.put(player.getUUID(), new Shake(Util.getMillis(), player.level(), durationTicks, intensityX, intensityY, intensityZ, fadeStartTick));
    }

    public static void applyShakeIfPresent(Player player, Camera camera) {
        Shake shake = SHAKES.get(player.getUUID());
        if (shake == null) {
            return;
        }
        if (shake.isExpired()) {
            SHAKES.remove(player.getUUID());
            return;
        }
        shake.apply(camera);
    }

    public static void clear() {
        SHAKES.values().removeIf(Shake::isExpired);
    }

    private record Shake(long startMillis, Level lvl, int durationTicks, float ix, float iy, float iz, int fadeStart) {
        void apply(Camera camera) {
            int elapsed = (int)((Util.getMillis() - this.startMillis) / 50L);
            float fade = 1.0f;
            if (this.fadeStart >= 0 && elapsed >= this.fadeStart) {
                fade = 1.0f - Math.min(1.0f, (float)(elapsed - this.fadeStart) / (float)(this.durationTicks - this.fadeStart));
            }
            float x = (float)((this.lvl.random.nextDouble() - 0.5) * (double)this.ix * (double)fade);
            float y = (float)((this.lvl.random.nextDouble() - 0.5) * (double)this.iy * (double)fade);
            float z = (float)((this.lvl.random.nextDouble() - 0.5) * (double)this.iz * (double)fade);
            ((CameraAccessor)camera).moveAccessor(x, y, z);
        }

        boolean isExpired() {
            return (Util.getMillis() - this.startMillis) / 50L >= (long)this.durationTicks;
        }
    }
}

