/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.block;

import dev.xylonity.knightlib.api.IGreatChaliceInteractable;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreatChaliceBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public GreatChaliceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return KnightLibBlockEntities.GREAT_CHALICE.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == KnightLibBlockEntities.GREAT_CHALICE.get() ? GreatChaliceBlockEntity::tick : null;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof GreatChaliceBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        GreatChaliceBlockEntity chalice = (GreatChaliceBlockEntity)blockEntity;
        ItemStack stack = pPlayer.getItemInHand(pHand);
        Item item = stack.getItem();
        if (item instanceof IGreatChaliceInteractable) {
            IGreatChaliceInteractable actor = (IGreatChaliceInteractable)item;
            if (!actor.canInteract(chalice, pLevel, pPlayer)) {
                return ItemInteractionResult.FAIL;
            }
            actor.onPreInteraction(chalice, pPlayer, pLevel, pHitResult);
            int total = chalice.getCharges() + actor.getChargesToApply();
            if (total < 0 || total > 12) {
                return ItemInteractionResult.FAIL;
            }
            chalice.setCharges(total);
            if (!pPlayer.getAbilities().instabuild) {
                stack.shrink(actor.shrinkItemAmount());
            }
            if (!actor.getRewards().isEmpty()) {
                for (ItemStack e : actor.getRewards()) {
                    ItemEntity entity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + (double)pPlayer.getBbHeight() * 0.5, (double)pPos.getZ(), e);
                    pLevel.addFreshEntity((Entity)entity);
                }
            }
            if (!actor.getInteractionSounds().isEmpty()) {
                for (SoundEvent sound : actor.getInteractionSounds()) {
                    pLevel.playSound(null, pPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (chalice.getCharges() == 12) {
                pLevel.playSound(null, pPos, actor.getFullChargeSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            actor.onPostInteraction(chalice, pPlayer, pLevel, pHitResult);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }
}

