/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.item;

import dev.xylonity.knightlib.api.IGreatChaliceInteractable;
import dev.xylonity.knightlib.api.impl.GreatChaliceState;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EmptyGrailItem
extends Item
implements IGreatChaliceInteractable {
    public EmptyGrailItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getChargesToApply() {
        return -12;
    }

    @Override
    public boolean canInteract(GreatChaliceBlockEntity chalice, Level level, Player player) {
        return chalice.isFull() && chalice.getState() == GreatChaliceState.NORMAL;
    }

    @Override
    @NotNull
    public Set<ItemStack> getRewards() {
        return Set.of(new ItemStack((ItemLike)KnightLibItems.FILLED_GRAIL.get()));
    }

    @Override
    @NotNull
    public Set<SoundEvent> getInteractionSounds() {
        return Set.of(SoundEvents.BREWING_STAND_BREW);
    }

    @Override
    public void onPostInteraction(GreatChaliceBlockEntity chalice, Player player, Level level, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            RandomSource rand = sv.getRandom();
            for (int i = 0; i < 25; ++i) {
                double r = 0.7 * Math.sqrt(rand.nextDouble());
                double t = rand.nextDouble() * Math.PI * 2.0;
                double px = (double)chalice.getBlockPos().getX() + 0.5 + r * Math.cos(t);
                double pz = (double)chalice.getBlockPos().getZ() + 0.5 + r * Math.sin(t);
                double py = (double)chalice.getBlockPos().getY() + 1.0 + rand.nextDouble() * 0.3;
                sv.sendParticles((ParticleOptions)ParticleTypes.EFFECT, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.item.knightlib.empty_grail"));
    }
}

