/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.LogType;
import dev.latvian.mods.kubejs.util.TimeJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class DataExport {
    @HideFromJS
    public static DataExport export = null;
    public CommandSourceStack source;
    private final Map<String, Callable<byte[]>> exportedFiles = new ConcurrentHashMap<String, Callable<byte[]>>();

    public static void exportData() {
        if (export != null) {
            try {
                export.exportData0();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            export = null;
        }
    }

    public void add(String path, Callable<byte[]> data) {
        try {
            this.exportedFiles.put(path, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addString(String path, String data) {
        this.add(path, () -> data.getBytes(StandardCharsets.UTF_8));
    }

    public void addJson(String path, JsonElement json) {
        this.add(path, () -> JsonUtils.toPrettyString(json).getBytes(StandardCharsets.UTF_8));
    }

    private void appendLine(StringBuilder sb, Calendar calendar, ConsoleLine line) {
        calendar.setTimeInMillis(line.timestamp);
        sb.append('[');
        TimeJS.appendTimestamp(sb, calendar);
        sb.append(']');
        sb.append(' ');
        sb.append('[');
        sb.append((Object)line.type);
        sb.append(']');
        sb.append(' ');
        if (line.type == LogType.ERROR) {
            sb.append('!');
            sb.append(' ');
        }
        sb.append(line.getText());
        sb.append('\n');
    }

    private void exportData0() throws Exception {
        this.source.registryAccess().registries().forEach(reg -> {
            ResourceKey key = reg.key();
            Registry registry = reg.value();
            JsonObject j = new JsonObject();
            for (Map.Entry entry : registry.entrySet()) {
                j.addProperty(((ResourceKey)entry.getKey()).location().toString(), entry.getValue() == null ? "null" : entry.getValue().getClass().getName());
            }
            this.addJson("registries/" + key.location().getPath() + ".json", (JsonElement)j);
        });
        StringBuilder logStringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        for (ConsoleLine consoleLine : ConsoleJS.SERVER.errors) {
            this.appendLine(logStringBuilder, calendar, consoleLine);
        }
        if (logStringBuilder.length() > 0) {
            logStringBuilder.setLength(logStringBuilder.length() - 1);
            this.addString("errors.log", logStringBuilder.toString());
        }
        logStringBuilder.setLength(0);
        for (ConsoleLine consoleLine : ConsoleJS.SERVER.warnings) {
            this.appendLine(logStringBuilder, calendar, consoleLine);
        }
        if (logStringBuilder.length() > 0) {
            logStringBuilder.setLength(logStringBuilder.length() - 1);
            this.addString("warnings.log", logStringBuilder.toString());
        }
        JsonArray modArr = new JsonArray();
        for (IModInfo mod : ModList.get().getMods()) {
            JsonObject o = new JsonObject();
            o.addProperty("id", mod.getModId().trim());
            o.addProperty("name", mod.getDisplayName().trim());
            o.addProperty("version", mod.getVersion().toString().trim());
            o.addProperty("description", mod.getDescription().trim());
            o.entrySet().removeIf(e -> {
                JsonPrimitive p;
                Object patt0$temp = e.getValue();
                return patt0$temp instanceof JsonPrimitive && (p = (JsonPrimitive)patt0$temp).isString() && p.getAsString().isEmpty();
            });
            modArr.add((JsonElement)o);
        }
        this.addJson("mods.json", (JsonElement)modArr);
        KubeJSPlugins.forEachPlugin(this, KubeJSPlugin::exportServerData);
        JsonArray jsonArray = new JsonArray();
        this.exportedFiles.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        this.addJson("index.json", (JsonElement)jsonArray);
        HashSet<String> exportedFilePaths = new HashSet<String>();
        for (String file2 : this.exportedFiles.keySet()) {
            exportedFilePaths.add(file2.replace(':', '/'));
        }
        Files.walk(KubeJSPaths.EXPORT, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return true;
            }
            return !exportedFilePaths.contains(KubeJSPaths.EXPORT.relativize((Path)path).toString().replace('\\', '/'));
        }).map(Path::toFile).forEach(file -> {
            if (file.isFile()) {
                file.delete();
                KubeJS.LOGGER.info("Deleted old file " + file.getPath());
            } else if (file.isDirectory() && file.list().length == 0) {
                file.delete();
                KubeJS.LOGGER.info("Deleted empty directory " + file.getPath());
            }
        });
        if (Files.notExists(KubeJSPaths.EXPORT, new LinkOption[0])) {
            Files.createDirectory(KubeJSPaths.EXPORT, new FileAttribute[0]);
        }
        CompletableFuture[] arr = new CompletableFuture[this.exportedFiles.size()];
        int i = 0;
        for (Map.Entry<String, Callable<byte[]>> entry : this.exportedFiles.entrySet()) {
            arr[i++] = CompletableFuture.runAsync(() -> {
                try {
                    Path path = KubeJSPaths.EXPORT.resolve(((String)entry.getKey()).replace(':', '/'));
                    Path parent = path.getParent();
                    if (Files.notExists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        Files.createFile(path, new FileAttribute[0]);
                    }
                    Files.write(path, (byte[])((Callable)entry.getValue()).call(), new OpenOption[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }, Util.ioPool());
        }
        CompletableFuture.allOf(arr).join();
        if (this.source.getServer().isSingleplayer()) {
            this.source.sendSuccess(() -> Component.literal((String)"Done! Export in local/kubejs/export").kjs$clickOpenFile(KubeJSPaths.EXPORT.toAbsolutePath().toString()), false);
        } else {
            this.source.sendSuccess(() -> Component.literal((String)"Done! Export in local/kubejs/export"), false);
        }
    }
}

