/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.block;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.block.ClaimShopBlockEntity;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.block.ClaimShopState;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.core.FTBChunksBlockEntities;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class ClaimShopBlock
extends TraderBlockRotatable
implements IVariantBlock {
    public ClaimShopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ClaimShopState.PROPERTY, (Comparable)((Object)ClaimShopState.INACTIVE)));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ClaimShopState.PROPERTY});
    }

    protected BlockEntity makeTrader(BlockPos blockPos, BlockState blockState) {
        return new ClaimShopBlockEntity(blockPos, blockState);
    }

    protected BlockEntityType<?> traderType() {
        return FTBChunksBlockEntities.CLAIM_SHOP.get();
    }

    public boolean canBreak(@Nonnull Player player, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        ClaimShopBlockEntity be;
        ClaimShopData shop;
        BlockEntity blockEntity = this.getBlockEntity(state, level, pos);
        if (blockEntity instanceof ClaimShopBlockEntity && (shop = (ClaimShopData)(be = (ClaimShopBlockEntity)blockEntity).getTraderData()) != null && shop.isCurrentlyRented()) {
            return false;
        }
        return super.canBreak(player, level, pos, state);
    }

    protected Supplier<List<Component>> getItemTooltips() {
        return FTBChunksText.TOOLTIP_CLAIM_SHOP.asTooltip(new Object[0]);
    }

    public int requiredModels() {
        return ClaimShopState.values().length;
    }

    public int getModelIndex(BlockState state) {
        return ((ClaimShopState)((Object)state.getValue(ClaimShopState.PROPERTY))).ordinal();
    }
}

