/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage;

import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage.ClaimGroupSettingsClientTab;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClaimGroupSettingsTab
extends TraderStorageTab {
    public ClaimGroupSettingsTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new ClaimGroupSettingsClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editSettings");
    }

    public void setGroup(String group) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editSettings")) {
            shop.setClaimGroup(group);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setString("ChangeGroup", group));
            }
        }
    }

    public void setLimit(int limit) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editSettings")) {
            shop.setGroupLimit(limit);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("ChangeLimit", limit));
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ChangeGroup")) {
            this.setGroup(message.getString("ChangeGroup"));
        }
        if (message.contains("ChangeLimit")) {
            this.setLimit(message.getInt("ChangeLimit"));
        }
    }
}

