/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones;

import io.github.lightman314.lightmanscompat.waystones.client.WaystonesClientNode;
import io.github.lightman314.lightmanscompat.waystones.requirements.MoneyRequirement;
import io.github.lightman314.lightmanscompat.waystones.requirements.functions.AddMoneyCost;
import io.github.lightman314.lightmanscompat.waystones.requirements.functions.MaxMoneyCost;
import io.github.lightman314.lightmanscompat.waystones.requirements.functions.MinMoneyCost;
import io.github.lightman314.lightmanscompat.waystones.requirements.functions.MultiplyMoneyCost;
import io.github.lightman314.lightmanscompat.waystones.requirements.functions.ScaledAddMoneyCost;
import io.github.lightman314.lightmanscompat.waystones.requirements.parameters.MoneyValueParameter;
import io.github.lightman314.lightmanscompat.waystones.requirements.parameters.ScaledMoneyValueParameter;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaystonesNode {
    public static final String WAYSTONES_MODID = "waystones";
    public static final Logger LOGGER = LogManager.getLogger();

    public static void setup(IEventBus bus, boolean client) {
        bus.addListener(WaystonesNode::commonSetup);
        if (client) {
            WaystonesClientNode.setup(bus);
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, (String)"Error occurred setting up Waystones Compat Node", () -> {
            LOGGER.info("Registering Waystone Requirements, Parameters, and Modifiers");
            WaystonesAPI.registerRequirementType(MoneyRequirement.TYPE);
            WaystonesAPI.registerParameterSerializer(MoneyValueParameter.SERIALIZER);
            WaystonesAPI.registerParameterSerializer(ScaledMoneyValueParameter.SERIALIZER);
            WaystonesAPI.registerRequirementModifier((RequirementFunction)AddMoneyCost.INSTANCE);
            WaystonesAPI.registerRequirementModifier((RequirementFunction)ScaledAddMoneyCost.INSTANCE);
            WaystonesAPI.registerRequirementModifier((RequirementFunction)MultiplyMoneyCost.INSTANCE);
            WaystonesAPI.registerRequirementModifier((RequirementFunction)MinMoneyCost.INSTANCE);
            WaystonesAPI.registerRequirementModifier((RequirementFunction)MaxMoneyCost.INSTANCE);
        });
    }
}

