/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones.requirements.parameters;

import com.mojang.brigadier.StringReader;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import net.blay09.mods.waystones.api.requirement.ParameterSerializer;
import net.minecraft.resources.ResourceLocation;

public record ScaledMoneyValueParameter(ResourceLocation data, float valuePerCost, MoneyValue price) {
    public static final ParameterSerializer<ScaledMoneyValueParameter> SERIALIZER = new Serializer();

    private static class Serializer
    implements ParameterSerializer<ScaledMoneyValueParameter> {
        private Serializer() {
        }

        public Class<ScaledMoneyValueParameter> getType() {
            return ScaledMoneyValueParameter.class;
        }

        public ScaledMoneyValueParameter deserialize(String s) {
            String[] split = s.split(",", 3);
            if (split.length != 3) {
                throw new IllegalArgumentException("Parameter count mismatch for type " + String.valueOf(ScaledMoneyValueParameter.class));
            }
            try {
                String id = split[0];
                ResourceLocation val1 = !id.contains(":") ? VersionUtil.modResource((String)"waystones", (String)id) : VersionUtil.parseResource((String)id);
                float val2 = Float.parseFloat(split[1]);
                MoneyValue val3 = MoneyValueParser.parse((StringReader)new StringReader(split[2]), (boolean)false);
                return new ScaledMoneyValueParameter(val1, val2, val3);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

