/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.bakery.core.block.entity.StreetSignBlockEntity;
import net.satisfy.bakery.core.network.PacketHandler;
import net.satisfy.bakery.core.network.SetStreetSignTextPacket;
import net.satisfy.bakery.core.util.BakeryIdentifier;

public class StreetSignEditGui
extends Screen {
    private final StreetSignBlockEntity entity;
    private final List<EditBox> textFields = new ArrayList<EditBox>();

    public StreetSignEditGui(StreetSignBlockEntity entity) {
        super((Component)Component.translatable((String)"gui.bakery.street_sign.edit"));
        this.entity = entity;
    }

    protected void init() {
        int[] offsetX = new int[]{75, 75, 75};
        int[] offsetY = new int[]{-15, -12, -15};
        for (int i = 0; i < 3; ++i) {
            EditBox box = new EditBox(this.font, this.width / 2 - 100 + offsetX[i], this.height / 2 - 30 + i * 24 + offsetY[i], 200, 20, (Component)Component.literal((String)""));
            box.setValue(this.entity.getText(i).getString());
            box.setMaxLength(8);
            box.setBordered(false);
            box.setTextColor(15255954);
            this.addRenderableWidget((GuiEventListener)box);
            this.textFields.add(box);
        }
        this.setInitialFocus((GuiEventListener)this.textFields.get(0));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.bakery.street_sign.done"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height - 40, 100, 20).build());
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderMenuBackground(graphics);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        ResourceLocation texture = BakeryIdentifier.identifier("textures/block/street_sign_front.png");
        int w = 128;
        int h = 128;
        int x = (int)((double)this.width / 2.0 - 65.0);
        int y = (int)((double)this.height / 2.0 - 65.0);
        graphics.blit(texture, x, y, w, h, 0.0f, 0.0f, 16, 16, 16, 16);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        List<String> texts = this.textFields.stream().map(EditBox::getValue).toList();
        PacketHandler.sendToServer(new SetStreetSignTextPacket(this.entity.getBlockPos(), texts));
        super.onClose();
    }
}

