/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.satisfy.bakery.core.compat.jei.category.BakerStationCategory;
import net.satisfy.bakery.core.recipe.BakingStationRecipe;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.RecipeTypeRegistry;
import net.satisfy.bakery.core.util.BakeryIdentifier;
import net.satisfy.farm_and_charm.core.compat.jei.category.CookingPotCategory;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BakeryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BakerStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List bakingRecipesHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.BAKING_STATION_RECIPE_TYPE.get());
        ArrayList bakingRecipes = new ArrayList();
        bakingRecipesHolders.forEach(bakingStationRecipeRecipeHolder -> bakingRecipes.add((BakingStationRecipe)bakingStationRecipeRecipeHolder.value()));
        registration.addRecipes(BakerStationCategory.CAKING, bakingRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return BakeryIdentifier.identifier("jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.BAKER_STATION.get()).asItem().getDefaultInstance(), new RecipeType[]{BakerStationCategory.CAKING});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.SMALL_COOKING_POT.get()).asItem().getDefaultInstance(), new RecipeType[]{CookingPotCategory.COOKING_POT});
    }
}

