/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.bakery.core.block.entity.StreetSignBlockEntity;
import net.satisfy.bakery.core.network.PacketHandler;

public record SetStreetSignTextPacket(BlockPos pos, List<String> texts) implements CustomPacketPayload
{
    public static CustomPacketPayload.Type<SetStreetSignTextPacket> TYPE = new CustomPacketPayload.Type(PacketHandler.SET_SIGN_TEXT);
    public static final StreamCodec<RegistryFriendlyByteBuf, SetStreetSignTextPacket> STREAM_CODEC = StreamCodec.of(SetStreetSignTextPacket::toNetwork, SetStreetSignTextPacket::fromNetwork);

    public static void toNetwork(RegistryFriendlyByteBuf buf, SetStreetSignTextPacket msg) {
        buf.writeBlockPos(msg.pos);
        buf.writeInt(msg.texts.size());
        for (String text : msg.texts) {
            buf.writeUtf(text);
        }
    }

    public static SetStreetSignTextPacket fromNetwork(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        int size = buf.readInt();
        ArrayList<String> texts = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            texts.add(buf.readUtf(50));
        }
        return new SetStreetSignTextPacket(pos, texts);
    }

    public static void handle(SetStreetSignTextPacket msg, ServerPlayer player) {
        BlockEntity entity;
        Level level = player.level();
        if (level.isLoaded(msg.pos) && (entity = level.getBlockEntity(msg.pos)) instanceof StreetSignBlockEntity) {
            StreetSignBlockEntity signEntity = (StreetSignBlockEntity)entity;
            for (int i = 0; i < msg.texts.size() && i < 4; ++i) {
                signEntity.setText(i, (Component)Component.literal((String)msg.texts.get(i)));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

