/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeachSunLounger
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    private final DyeColor color;
    private static final Supplier<VoxelShape> bottomShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.36875, (double)0.0625, (double)1.0, (double)0.49375, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.1875, (double)0.25, (double)0.125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, bottomShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0, (double)0.3125, (double)0.375, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.36875, (double)0.0625, (double)0.25, (double)0.49375, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)0.125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.875, (double)0.3125, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, topShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeDownSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0, (double)0.375, (double)0.375, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.36875, (double)0.0625, (double)0.25, (double)0.49375, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)0.125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.875, (double)0.3125, (double)0.25, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.36875, (double)0.0625, (double)0.9375, (double)0.49375, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE_DOWN = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, topShapeDownSupplier.get()));
        }
    });

    public BeachSunLounger(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties.forceSolidOn());
        this.color = dyeColor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public static Direction getOppositePartDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == BedPart.HEAD ? direction.getOpposite() : direction;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (state.getValue(PART) == BedPart.HEAD) {
            return (Boolean)state.getValue((Property)DOWN) != false ? TOP_SHAPE_DOWN.get(direction) : TOP_SHAPE.get(direction);
        }
        return BOTTOM_SHAPE.get(direction);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == BeachSunLounger.getDirectionTowardsOtherPart((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART) ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            this.removeOtherPart(world, pos, state, player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getHorizontalDirection().getClockWise();
        BlockPos blockPos = ctx.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        Level world = ctx.getLevel();
        return world.getBlockState(blockPos2).canBeReplaced(ctx) && world.getWorldBorder().isWithinBounds(blockPos2) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            this.placeOtherPart(world, pos, state);
        }
    }

    private void placeOtherPart(Level world, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
        world.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
        world.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
    }

    private void removeOtherPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart = (BedPart)state.getValue(PART);
        if (bedPart == BedPart.FOOT && (blockState = world.getBlockState(blockPos = pos.relative(BeachSunLounger.getDirectionTowardsOtherPart(bedPart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue(PART) == BedPart.HEAD) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            if (player != null) {
                world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, DOWN, OCCUPIED});
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float factor) {
        super.fallOn(level, state, pos, entity, factor * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter getter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 deltaMovement = entity.getDeltaMovement();
        if (deltaMovement.y < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 0.75 : 0.8;
            entity.setDeltaMovement(deltaMovement.x, -deltaMovement.y * 0.3300000262260437 * bounceFactor, deltaMovement.z);
        }
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).stopSleeping();
        return true;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (blockState.getValue(PART) == BedPart.HEAD && player.isShiftKeyDown()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)DOWN, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)DOWN) == false)), 3);
            level.playSound(null, blockPos, SoundEvents.BAMBOO_WOOD_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (blockState.getValue(PART) != BedPart.HEAD && !(blockState = level.getBlockState(blockPos = blockPos.relative((Direction)blockState.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!((Boolean)blockState.getValue((Property)DOWN)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        if (!BeachSunLounger.canSetSpawn((Level)level)) {
            level.removeBlock(blockPos, false);
            BlockPos blockPos2 = blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite());
            if (level.getBlockState(blockPos2).is((Block)this)) {
                level.removeBlock(blockPos2, false);
            }
            Vec3 vec3 = blockPos.getCenter();
            level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)blockState.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, blockPos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState finalBlockState = blockState;
        BlockPos finalBlockPos = blockPos;
        player.startSleepInBed(finalBlockPos).ifRight(success -> level.setBlock(finalBlockPos, (BlockState)finalBlockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 3)).ifLeft(bedSleepingProblem -> {
            if (bedSleepingProblem.getMessage() != null) {
                player.displayClientMessage(bedSleepingProblem.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }
}

