/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class PalmGlassPaneBlock
extends IronBarsBlock {
    public static final IntegerProperty PART = IntegerProperty.create((String)"part", (int)0, (int)3);

    public PalmGlassPaneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            this.updateAllConnected(world, pos);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        if (!world.isClientSide()) {
            this.updateAllConnected(world, pos);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, world, pos, newState, isMoving);
        if (!world.isClientSide() && state.getBlock() != newState.getBlock()) {
            BlockPos up = pos.above();
            BlockPos down = pos.below();
            if (world.getBlockState(up).getBlock() == this) {
                this.updateAllConnected(world, up);
            }
            if (world.getBlockState(down).getBlock() == this) {
                this.updateAllConnected(world, down);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    private void updateAllConnected(Level world, BlockPos start) {
        LinkedList<Vector3i> queue = new LinkedList<Vector3i>();
        HashSet<Vector3i> visited = new HashSet<Vector3i>();
        Vector3i origin = new Vector3i(start.getX(), start.getY(), start.getZ());
        queue.add(origin);
        visited.add(origin);
        while (!queue.isEmpty()) {
            Vector3i current = (Vector3i)queue.poll();
            for (Direction d : Direction.values()) {
                Vector3i next = new Vector3i(current.x + d.getStepX(), current.y + d.getStepY(), current.z + d.getStepZ());
                BlockPos bp = new BlockPos(next.x, next.y, next.z);
                if (world.getBlockState(bp).getBlock() != this || visited.contains(next)) continue;
                visited.add(next);
                queue.add(next);
            }
        }
        HashMap<Long, List> columns = new HashMap<Long, List>();
        for (Vector3i v : visited) {
            long key = (long)v.x << 32 ^ (long)v.z & 0xFFFFFFFFL;
            columns.computeIfAbsent(key, k -> new ArrayList()).add(v);
        }
        for (List col : columns.values()) {
            col.sort(Comparator.comparingInt(o -> o.y));
            for (int i = 0; i < col.size(); ++i) {
                Vector3i v = (Vector3i)col.get(i);
                BlockPos bp = new BlockPos(v.x, v.y, v.z);
                BlockState s = world.getBlockState(bp);
                int size = col.size();
                int part = size == 1 ? 0 : (i == 0 ? 1 : (i == size - 1 ? 3 : 2));
                world.setBlock(bp, (BlockState)s.setValue((Property)PART, (Comparable)Integer.valueOf(part)), 3);
            }
        }
    }
}

