/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class ThrowableCoconutEntity
extends ThrowableItemProjectile {
    public ThrowableCoconutEntity(Level world, LivingEntity owner) {
        super((EntityType)EntityTypeRegistry.COCONUT.get(), owner, world);
    }

    public ThrowableCoconutEntity(EntityType<? extends ThrowableCoconutEntity> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ObjectRegistry.COCONUT.get();
    }

    private ParticleOptions getParticleParameters() {
        return new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)ObjectRegistry.COCONUT.get()));
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            Level level = this.level();
            for (int i = 0; i < 30; ++i) {
                double ox = this.random.nextGaussian() * 0.02;
                double oy = this.random.nextGaussian() * 0.02;
                double oz = this.random.nextGaussian() * 0.02;
                level.addParticle(this.getParticleParameters(), this.getX() + ox, this.getY() + oy, this.getZ() + oz, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity target = result.getEntity();
        int damage = 2;
        target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level level = this.level();
        if (!level.isClientSide) {
            level.broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.WOOD_FALL, 1.0f, 1.0f);
            this.spawnAtLocation((ItemLike)ObjectRegistry.COCONUT_OPEN.get());
            this.spawnAtLocation((ItemLike)ObjectRegistry.COCONUT_OPEN.get());
            if (level.getRandom().nextFloat() < 0.45f) {
                this.spawnAtLocation((ItemLike)ObjectRegistry.PALM_SPROUT.get());
            }
            this.discard();
        }
    }
}

