/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.brewery.core.network.BreweryNetworking;
import net.satisfy.brewery.core.network.packet.SetWallDecorationTextPacket;

public class WallDecorationEditGui
extends Screen {
    private final WallDecorationBlockEntity entity;
    private EditBox textField;

    public WallDecorationEditGui(WallDecorationBlockEntity entity) {
        super((Component)Component.translatable((String)"gui.brewery.wall_decoration.edit"));
        this.entity = entity;
    }

    protected void init() {
        int offsetX = 82;
        int offsetY = 7;
        this.textField = new EditBox(this.font, this.width / 2 - 100 + offsetX, this.height / 2 - 30 + offsetY, 200, 20, (Component)Component.literal((String)""));
        this.textField.setValue(this.entity.getText(0).getString());
        this.textField.setMaxLength(8);
        this.textField.setBordered(false);
        this.textField.setTextColor(16441264);
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.setInitialFocus((GuiEventListener)this.textField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.brewery.wall_decoration.done"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height - 40, 100, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        ResourceLocation texture = Brewery.identifier("textures/block/gingerbread_heart.png");
        int w = 128;
        int h = 128;
        int x = (int)((double)this.width / 2.0 - 65.0);
        int y = (int)((double)this.height / 2.0 - 90.0);
        graphics.blit(texture, x, y, w, h, 0.0f, 0.0f, 16, 16, 16, 16);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderMenuBackground(graphics);
    }

    public void onClose() {
        List<String> texts = List.of(this.textField.getValue());
        BreweryNetworking.sendSetSignTextToServer(new SetWallDecorationTextPacket(this.entity.getBlockPos(), texts));
        super.onClose();
    }
}

