/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.entity.BeerMugBlockEntity;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeerMugFlowerPotBlock
extends FacingBlock
implements EntityBlock {
    private static final VoxelShape SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;

    public BeerMugFlowerPotBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null || !context.getPlayer().isCrouching()) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BeerMugBlockEntity be = (BeerMugBlockEntity)level.getBlockEntity(pos);
        if (be == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack handStack = player.getItemInHand(hand);
        Item flower = be.getFlower();
        if (flower == null && handStack.isEmpty() && !player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                player.addItem(new ItemStack((ItemLike)ObjectRegistry.BEER_MUG.get()));
                level.removeBlock(pos, false);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (player.isShiftKeyDown() && flower != null) {
            if (!level.isClientSide) {
                player.addItem(new ItemStack((ItemLike)flower));
                be.setFlower(null);
                level.sendBlockUpdated(pos, state, state, 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isShiftKeyDown() && handStack.isEmpty() && flower != null) {
            if (!level.isClientSide) {
                player.addItem(flower.getDefaultInstance());
                be.setFlower(null);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isShiftKeyDown() && this.fitInPot(handStack) && flower == null) {
            if (!level.isClientSide) {
                be.setFlower(handStack.getItem());
                if (!player.isCreative()) {
                    handStack.shrink(1);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, hit);
    }

    public boolean fitInPot(ItemStack item) {
        return item.is(ItemTags.SMALL_FLOWERS);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BeerMugBlockEntity) {
                BeerMugBlockEntity be = (BeerMugBlockEntity)blockEntity;
                Item flower = be.getFlower();
                if (flower != null) {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)flower.getDefaultInstance());
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BeerMugBlockEntity(pos, state);
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.5, (double)0.375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.625, (double)0.6875, (double)0.5, (double)0.6875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.375, (double)0.6875, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.375, (double)0.375, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        SHAPE = voxelShapeSupplier.get();
    }
}

