/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.block.property.Heat;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BrewOvenBlock
extends BrewingstationBlock {
    public static final EnumProperty<Heat> HEAT = BlockStateRegistry.HEAT;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    private long lastSoundTime = 0L;

    public BrewOvenBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> BrewOvenBlock.hasHeat(state) ? 13 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).setValue(HEAT, (Comparable)((Object)Heat.OFF)));
    }

    private static boolean hasHeat(BlockState state) {
        return state.getValue(HEAT) != Heat.OFF;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (blockState.getValue(HEAT) != Heat.LIT && AbstractFurnaceBlockEntity.getFuel().containsKey(itemStack.getItem())) {
            level.setBlock(blockPos, (BlockState)blockState.setValue(HEAT, (Comparable)((Object)Heat.LIT)), 3);
            level.playSound(null, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        boolean isHeated;
        boolean bl = isHeated = state.getValue(HEAT) != Heat.OFF;
        if (isHeated && !entity.fireImmune() && entity instanceof Player) {
            entity.hurt(world.damageSources().inFire(), 1.0f);
        }
        super.stepOn(world, pos, state, entity);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (blockState.getValue(HEAT) != Heat.OFF) {
            double k;
            double x = (double)blockPos.getX() + 0.5;
            double y = (double)blockPos.getY() + 0.7;
            double z = (double)blockPos.getZ() + 0.5;
            if (randomSource.nextDouble() < 0.1) {
                level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = ((Direction)blockState.getValue((Property)FACING)).getCounterClockWise();
            Direction.Axis axis = direction.getAxis();
            double h = randomSource.nextDouble() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.62 : h;
            double j = randomSource.nextDouble() * 9.0 / 16.0;
            double d = k = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.62 : h;
            if (blockState.getValue(HEAT) == Heat.WEAK) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastSoundTime >= 9500L) {
                    level.playLocalSound(x, y, z, (SoundEvent)SoundEventRegistry.BREWSTATION_OVEN.get(), SoundSource.BLOCKS, 0.7f, 1.0f, false);
                    this.lastSoundTime = currentTime;
                }
                if (randomSource.nextDouble() < 0.2) {
                    for (int l = 0; l < 5; ++l) {
                        level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, x + i, y + j, z + k, 0.0, 0.01, 0.0);
                    }
                }
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + i, y + j, z + k, 0.0, 0.07, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, x + i, y + j, z + k, 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT});
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.9375));
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
    }
}

