/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.event;

import dev.architectury.event.events.common.LootEvent;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.satisfy.brewery.Brewery;

public class LoottableInjector {
    public static void InjectLoot(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context) {
        String prefix = "minecraft:chests/";
        String name = key.toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "village/village_taiga_house": 
                case "woodland_mansion": 
                case "pillager_outpost": 
                case "village/village_desert_house": 
                case "village/village_plains_house": 
                case "village/village_savanna_house": {
                    context.addPool(LoottableInjector.getPool(file));
                    break;
                }
            }
        }
    }

    public static LootPool.Builder getPool(String entryName) {
        return LootPool.lootPool().add(LoottableInjector.getPoolEntry(entryName));
    }

    private static LootPoolEntryContainer.Builder getPoolEntry(String name) {
        ResourceKey table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Brewery.identifier("chests/" + name));
        return NestedLootTable.lootTableReference((ResourceKey)table);
    }
}

