/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class MeowAtBowlGoal
extends Goal {
    private final Cat cat;
    private BlockPos bowlPos;
    private int meowTicks;
    private long lastCheckTime;
    private boolean active;
    private static final int CHECK_INTERVAL_TICKS = 40;
    private static final int MAX_MEOW_TICKS = 300;
    private static final int MEOW_INTERVAL = 60;
    private static final int ANGRY_PARTICLE_INTERVAL = 100;
    private static final double NAVIGATION_SPEED = 1.0;
    private static final double CLOSE_ENOUGH_DIST = 1.1;
    private static final double LOOK_OFFSET = 0.5;
    private static final long MORNING_START = 5800L;
    private static final long MORNING_END = 6200L;
    private static final long EVENING_START = 11500L;
    private static final long EVENING_END = 12500L;

    public MeowAtBowlGoal(Cat cat) {
        this.cat = cat;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.meowTicks = 0;
        this.lastCheckTime = -1L;
        this.active = false;
    }

    public boolean canUse() {
        if (!this.cat.isTame() || this.cat.isOrderedToSit()) {
            return false;
        }
        Level level = this.cat.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        long gameTime = server.getGameTime();
        if (this.lastCheckTime != -1L && gameTime - this.lastCheckTime < 40L) {
            return false;
        }
        this.lastCheckTime = gameTime;
        long timeOfDay = server.getDayTime() % 24000L;
        if (timeOfDay < 5800L || timeOfDay > 6200L && timeOfDay < 11500L || timeOfDay > 12500L) {
            return false;
        }
        BlockPos catPos = this.cat.blockPosition();
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)catPos.offset(-32, -4, -32), (BlockPos)catPos.offset(32, 4, 32))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            if (!level.getBlockState(pos).is((Block)ObjectRegistry.PET_BOWL.get()) || !level.getBlockState(pos).hasBlockEntity() || !((be = level.getBlockEntity(pos)) instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).isEmpty() || !bowl.canBeUsedBy((Animal)this.cat) || !((dist = this.cat.position().distanceToSqr(Vec3.atCenterOf((Vec3i)pos))) < closestDistance)) continue;
            closestDistance = dist;
            closest = pos.immutable();
        }
        if (closest != null) {
            this.bowlPos = closest;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        PetBowlBlockEntity bowl;
        if (!this.active || this.meowTicks >= 300 || this.bowlPos == null) {
            return false;
        }
        Level level = this.cat.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.getBlockEntity(this.bowlPos);
        return be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).isEmpty() && bowl.canBeUsedBy((Animal)this.cat);
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        if (this.bowlPos != null) {
            if (!this.isNearBowl()) {
                this.cat.getNavigation().moveTo((double)this.bowlPos.getX() + 0.5, (double)this.bowlPos.getY(), (double)this.bowlPos.getZ() + 0.5, 1.0);
            }
            this.meowTicks = 0;
            this.active = true;
        }
    }

    public void tick() {
        Vec3 pos;
        PetBowlBlockEntity bowl;
        if (this.bowlPos == null) {
            this.stop();
            return;
        }
        Level level = this.cat.level();
        if (!(level instanceof ServerLevel)) {
            this.stop();
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.getBlockEntity(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).isEmpty()) {
            this.stop();
            return;
        }
        if (this.isNearBowl()) {
            if (this.cat.getNavigation().isInProgress()) {
                this.cat.getNavigation().stop();
            }
            if (!this.cat.isOrderedToSit()) {
                this.cat.setOrderedToSit(true);
            }
            this.cat.getLookControl().setLookAt((double)this.bowlPos.getX() + 0.5, (double)this.bowlPos.getY() + 0.5, (double)this.bowlPos.getZ() + 0.5);
        } else if (!this.cat.getNavigation().isInProgress()) {
            this.cat.getNavigation().moveTo((double)this.bowlPos.getX() + 0.5, (double)this.bowlPos.getY(), (double)this.bowlPos.getZ() + 0.5, 1.0);
        }
        if (this.meowTicks % 60 == 0) {
            this.cat.playSound(SoundEvents.CAT_BEG_FOR_FOOD, 1.0f, 1.0f);
        }
        if (this.meowTicks % 100 == 0) {
            pos = this.cat.position().add(0.0, 0.5, 0.0);
            server.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y, pos.z, 6, 0.3, 0.3, 0.3, 0.01);
        }
        if (++this.meowTicks >= 300) {
            this.cat.playSound(SoundEvents.CAT_HISS, 1.0f, 1.0f);
            pos = this.cat.position().add(0.0, 0.5, 0.0);
            server.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y, pos.z, 15, 0.3, 0.3, 0.3, 0.01);
            this.stop();
        }
    }

    public void stop() {
        this.bowlPos = null;
        this.meowTicks = 0;
        this.active = false;
        if (this.cat.isOrderedToSit()) {
            this.cat.setOrderedToSit(false);
        }
    }

    private boolean isNearBowl() {
        return this.bowlPos != null && this.cat.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.bowlPos)) < 1.2100000000000002;
    }
}

