/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.core.network.handler.SyncSaturationPacketClientHandler;
import net.satisfy.farm_and_charm.core.network.packet.SetTextPacket;
import net.satisfy.farm_and_charm.core.network.packet.SyncSaturationPacket;

public class PacketHandler {
    public static final ResourceLocation SET_SIGN_TEXT = FarmAndCharm.identifier("set_text");
    public static final ResourceLocation SYNC_SATURATION = FarmAndCharm.identifier("sync_saturation");

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), SetTextPacket.TYPE, SetTextPacket.STREAM_CODEC, (pkt, ctx) -> ctx.queue(() -> SetTextPacket.handle(pkt, (ServerPlayer)ctx.getPlayer())));
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncSaturationPacket.TYPE, SyncSaturationPacket.STREAM_CODEC, (pkt, ctx) -> ctx.queue(() -> SyncSaturationPacketClientHandler.handle(pkt)));
        } else {
            NetworkManager.registerS2CPayloadType(SyncSaturationPacket.TYPE, SyncSaturationPacket.STREAM_CODEC);
        }
    }

    public static void sendSaturationSync(SyncSaturationPacket packet, Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.players()) {
                if (!NetworkManager.canPlayerReceive((ServerPlayer)player, SyncSaturationPacket.TYPE)) continue;
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
            }
        }
    }

    public static void sendToClient(ServerPlayer player, SyncSaturationPacket packet) {
        if (NetworkManager.canPlayerReceive((ServerPlayer)player, SyncSaturationPacket.TYPE)) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
        }
    }

    public static void sendToServer(SetTextPacket packet) {
        NetworkManager.sendToServer((CustomPacketPayload)packet);
    }
}

