/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.world.ImplementedInventory;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<CauldronBlockEntity>,
MenuProvider {
    public static final int CAPACITY = 5;
    private static final int[] SLOTS_FOR_SIDE = new int[]{0, 4};
    private static final int[] SLOTS_FOR_UP = new int[]{1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3};
    private NonNullList<ItemStack> inventory;
    private int brewingTime = 0;
    private int totalBrewingTime;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CauldronBlockEntity.this.brewingTime;
                case 1 -> CauldronBlockEntity.this.totalBrewingTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CauldronBlockEntity.this.brewingTime = value;
                    break;
                }
                case 1: {
                    CauldronBlockEntity.this.totalBrewingTime = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public CauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CAULDRON_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        this.brewingTime = compoundTag.getInt("BrewingTime");
        this.totalBrewingTime = compoundTag.getInt("TotalBrewingTime");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putInt("BrewingTime", this.brewingTime);
        compoundTag.putInt("TotalBrewingTime", this.totalBrewingTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, CauldronBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        boolean dirty = false;
        if (this.canCraft()) {
            ++this.brewingTime;
            if (this.brewingTime >= this.totalBrewingTime) {
                this.brewingTime = 0;
                this.craft(world);
                dirty = true;
            }
        } else {
            this.brewingTime = 0;
        }
        if (dirty) {
            this.setChanged();
        }
    }

    private boolean canCraft() {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getItem(i);
            if (!stack.isEmpty() && stack.getItem() instanceof PotionItem) continue;
            return false;
        }
        ItemStack catalyst = this.getItem(4);
        if (catalyst.isEmpty() || catalyst.getItem() != ObjectRegistry.HERBAL_INFUSION.get()) {
            return false;
        }
        ItemStack output = this.getItem(3);
        return output.isEmpty();
    }

    private void craft(Level world) {
        ArrayList combinedEffects = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            ItemStack potionStack = this.getItem(i);
            List potionEffects = StreamSupport.stream(((PotionContents)potionStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects().spliterator(), false).toList();
            combinedEffects.addAll(potionEffects);
        }
        HashMap<Holder, MobEffectInstance> uniqueEffectsMap = new HashMap<Holder, MobEffectInstance>();
        for (MobEffectInstance effectInstance : combinedEffects) {
            Holder effect = effectInstance.getEffect();
            if (uniqueEffectsMap.containsKey(effect) && effectInstance.getAmplifier() <= ((MobEffectInstance)uniqueEffectsMap.get(effect)).getAmplifier()) continue;
            uniqueEffectsMap.put(effect, new MobEffectInstance(effect, effectInstance.getDuration(), effectInstance.getAmplifier()));
        }
        ItemStack outputPotion = new ItemStack((ItemLike)ObjectRegistry.FLASK.get());
        PotionContents potionContents = (PotionContents)outputPotion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        RandomSource random = world != null ? world.getRandom() : RandomSource.create();
        int randomTexture = random.nextInt(6) + 1;
        outputPotion.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(randomTexture));
        for (MobEffectInstance effectInstance : uniqueEffectsMap.values()) {
            potionContents = potionContents.withEffectAdded(effectInstance);
        }
        outputPotion.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        this.setItem(3, outputPotion);
        for (int i = 0; i < 3; ++i) {
            this.removeItem(i, 1);
        }
        this.removeItem(4, 1);
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.matches((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (slot < 3 && !dirty) {
            this.totalBrewingTime = PlatformHelper.getBrewingDuration();
            this.brewingTime = 0;
            this.setChanged();
        }
        if (slot == 4 && !dirty) {
            this.setChanged();
        }
    }

    @Override
    public boolean stillValid(Player player) {
        assert (this.level != null);
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new CauldronGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

