/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BondingEffect
extends MobEffect {
    public BondingEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isAlive()) {
            int finalAmplifier;
            Level world = player.level();
            double radius = 10.0;
            List nearbyPlayers = world.getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(radius), this::isAffectedEntity);
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(playerCount)) > 0) {
                nearbyPlayers.stream().filter(p -> p.isAlive() && p != player && !p.isCreative()).forEach(p -> {
                    p.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 50, finalAmplifier, false, false, false));
                    p.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 50, finalAmplifier, false, false, false));
                });
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    private int calculateFinalAmplifier(int playerCount) {
        float baseAmplifier = 1.0f;
        float reductionPerPlayer = 0.1f;
        float calculatedAmplifier = baseAmplifier - (float)playerCount * reductionPerPlayer;
        if (calculatedAmplifier < 0.0f) {
            calculatedAmplifier = 0.0f;
        }
        int finalAmplifier = Math.round(calculatedAmplifier);
        return Math.max(0, Math.min(finalAmplifier, 3));
    }

    private boolean isAffectedEntity(Player player) {
        return player.isAlive() && !player.isCreative();
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int j) {
        return true;
    }
}

