/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModStats {
    private static final Map<ResourceLocation, StatFormatter> formatterRegistry = new HashMap<ResourceLocation, StatFormatter>();
    public static final ResourceLocation STAT_TRADES = ModStats.registerCustom("trade_interactions", StatFormatter.DEFAULT);
    public static final ResourceLocation STAT_AUCTION_BIDS = ModStats.registerCustom("auction_bids", StatFormatter.DEFAULT);
    public static final ResourceLocation STAT_AUCTION_WINS = ModStats.registerCustom("auction_wins", StatFormatter.DEFAULT);

    public static void init() {
    }

    private static ResourceLocation registerCustom(String name, StatFormatter formatter) {
        ResourceLocation id = VersionUtil.lcResource(name);
        ModRegistries.CUSTOM_STAT.register(name, () -> id);
        formatterRegistry.put(id, formatter);
        return id;
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            formatterRegistry.forEach((arg_0, arg_1) -> ((StatType)Stats.CUSTOM).get(arg_0, arg_1));
            formatterRegistry.clear();
        });
    }
}

