/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TicketRecipe
implements TicketStationRecipe {
    public static final MapCodec<TicketRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("masterTicket").forGetter(r -> r.masterIngredient), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("result").forGetter(r -> r.ticketResult), (App)DurabilityData.CODEC.optionalFieldOf("durability").forGetter(r -> r.durability.asOptional())).apply((Applicative)builder, TicketRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TicketRecipe> STREAM_CODEC = StreamCodec.of(TicketRecipe::toNetwork, TicketRecipe::fromNetwork);
    private final Ingredient masterIngredient;
    private final Ingredient ingredient;
    private final Item ticketResult;
    private final DurabilityData durability;

    public Ingredient getMasterIngredient() {
        return this.masterIngredient;
    }

    private TicketRecipe(Ingredient masterIngredient, Ingredient ingredient, Item result, Optional<DurabilityData> durabilityData) {
        this(masterIngredient, ingredient, result, durabilityData.orElse(DurabilityData.NULL));
    }

    public TicketRecipe(Ingredient masterIngredient, Ingredient ingredient, Item result, DurabilityData durabilityData) {
        this.masterIngredient = masterIngredient;
        this.ingredient = ingredient;
        this.ticketResult = result;
        this.durability = durabilityData;
    }

    @Override
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleTicketList(this.masterIngredient);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack exampleResult() {
        return new ItemStack((ItemLike)this.ticketResult);
    }

    @Override
    public boolean consumeModifier() {
        return false;
    }

    @Override
    public boolean validModifier(ItemStack stack) {
        return this.masterIngredient.test(stack);
    }

    @Override
    public boolean validIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Override
    public DurabilityData getDurabilityData() {
        return this.durability;
    }

    public ItemStack assemble(TicketStationRecipeInput container, HolderLookup.Provider lookup) {
        return this.applyDurability(TicketItem.CraftTicket(container.getItem(0), this.ticketResult), container.data);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        if (this.masterIngredient.getItems().length == 0) {
            return ItemStack.EMPTY;
        }
        return TicketItem.CraftTicket(TicketItem.CreateTicket(this.masterIngredient.getItems()[0].getItem(), -1L), this.ticketResult);
    }

    @Override
    public ItemStack peekAtResult(Container container, TicketStationRecipe.ExtraData data) {
        return this.applyDurability(TicketItem.CraftTicket(container.getItem(0), this.ticketResult), data);
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellItem, TicketStationRecipe.ExtraData data) {
        return this.applyDurability(TicketItem.CraftTicket(sellItem, this.ticketResult), data);
    }

    private ItemStack applyDurability(ItemStack ticket, TicketStationRecipe.ExtraData data) {
        if (this.durability.isValid() && data.durability() > 0 && this.durability.test(data.durability())) {
            ticket.set(ModDataComponents.TICKET_USES, (Object)data.durability());
        }
        return ticket;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TICKET.get();
    }

    private static TicketRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        return new TicketRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Item)TicketStationRecipe.itemStreamCodec().decode((Object)buffer), (DurabilityData)DurabilityData.STREAM_CODEC.decode((Object)buffer));
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, TicketRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.masterIngredient);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        TicketStationRecipe.itemStreamCodec().encode((Object)buffer, (Object)recipe.ticketResult);
        DurabilityData.STREAM_CODEC.encode((Object)buffer, (Object)recipe.durability);
    }

    public static class Serializer
    implements RecipeSerializer<TicketRecipe> {
        public MapCodec<TicketRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TicketRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

