/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.data.ItemStackData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaBallItem
extends Item {
    public static final int MAX_INCEPTION_LEVEL = 16;

    public GachaBallItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack ball = player.getItemInHand(hand);
        if (ball.getItem() instanceof GachaBallItem) {
            ItemStack contents = ((ItemStackData)ball.getOrDefault(ModDataComponents.GACHA_ITEM, (Object)ItemStackData.EMPTY)).stack();
            ball.shrink(1);
            if (ball.isEmpty()) {
                return InteractionResultHolder.success((Object)contents);
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)contents);
            return InteractionResultHolder.success((Object)ball);
        }
        return super.use(level, player, hand);
    }

    public static ItemStack createWithItem(ItemStack contents) {
        return GachaBallItem.createWithItem(contents, RandomSource.create());
    }

    public static ItemStack createWithItem(ItemStack contents, RandomSource random) {
        return GachaBallItem.createWithItemAndColor(contents, Color.getFromIndex(random.nextInt(Color.values().length)));
    }

    public static ItemStack createWithItemAndColor(ItemStack contents, Color color) {
        return GachaBallItem.createWithItemAndColor(contents, color.hexColor);
    }

    public static ItemStack createWithItemAndColor(ItemStack contents, int color) {
        if (InventoryUtil.ItemHasTag(contents, LCTags.Items.GACHA_BLACKLIST) || GachaBallItem.inceptionLevel(contents) >= 16) {
            return contents.copy();
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.GACHA_BALL.get());
        stack.set(ModDataComponents.GACHA_ITEM, (Object)new ItemStackData(contents.copy()));
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
        return stack;
    }

    public static ItemStack makeEmptyCopy(ItemStack gachaBall) {
        return GachaBallItem.createWithItemAndColor(ItemStack.EMPTY, ((DyedItemColor)gachaBall.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF, true))).rgb());
    }

    public static int inceptionLevel(ItemStack stack) {
        int count = 0;
        ItemStack queryStack = stack;
        while (queryStack.getItem() == ModItems.GACHA_BALL.get()) {
            queryStack = GachaBallItem.getContents(queryStack);
            ++count;
        }
        return count;
    }

    public static ItemStack getContents(ItemStack stack) {
        return ((ItemStackData)stack.getOrDefault(ModDataComponents.GACHA_ITEM, (Object)ItemStackData.EMPTY)).stack();
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (flag.isAdvanced()) {
            ItemStack contents = ((ItemStackData)stack.getOrDefault(ModDataComponents.GACHA_ITEM, (Object)ItemStackData.EMPTY)).stack();
            if (contents.isEmpty()) {
                return;
            }
            tooltip.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS.get(contents.getCount(), contents.getHoverName()).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

