/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.codecs.LCCodecs;
import io.github.lightman314.lightmanscurrency.common.blockentity.MoneyBagBlockEntity;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record MoneyBagData(List<ItemStack> contents, @Range(from=0L, to=3L) int size) implements TooltipProvider
{
    public static final MoneyBagData EMPTY = new MoneyBagData((List<ItemStack>)ImmutableList.of(), 0);
    public static final Codec<MoneyBagData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LCCodecs.UNLIMITED_ITEM_OPTIONAL.listOf().fieldOf("contents").forGetter(MoneyBagData::contents), (App)Codec.INT.fieldOf("size").forGetter(MoneyBagData::size)).apply((Applicative)builder, MoneyBagData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MoneyBagData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeInt(d.contents.size());
        for (ItemStack i : d.contents) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(b, (Object)i);
        }
        b.writeInt(d.size);
    }, b -> {
        int itemCount = b.readInt();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < itemCount; ++i) {
            list.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(b));
        }
        return new MoneyBagData((List<ItemStack>)ImmutableList.copyOf(list), b.readInt());
    });

    public static MoneyBagData of(List<ItemStack> contents) {
        int size = MoneyBagBlockEntity.getBlockSize(contents);
        return new MoneyBagData((List<ItemStack>)ImmutableList.copyOf(InventoryUtil.copyList(contents)), size);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
    }
}

