/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.items.data.FilterData;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemFilterMenu
extends LazyMessageMenu {
    private final int itemIndex;
    private Consumer<ItemStack> quickMoveConsumer = s -> {};

    public FilterData getData() {
        return (FilterData)this.getTargetedStack().getOrDefault(ModDataComponents.FILTER_DATA, (Object)FilterData.EMPTY);
    }

    public ItemFilterMenu(int id, Inventory inventory, int itemIndex) {
        this(ModMenus.ITEM_FILTER.get(), id, inventory, itemIndex);
    }

    protected ItemFilterMenu(MenuType<?> type, int id, Inventory inventory, int itemIndex) {
        super(type, id, inventory);
        this.itemIndex = itemIndex;
        this.addValidator(() -> !this.getTargetedStack().isEmpty());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + y * 9 + 9;
                this.addSlot(new Slot((Container)inventory, index, 8 + x * 18, 134 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 192));
        }
    }

    public final ItemStack getTargetedStack() {
        if (this.itemIndex < 0 || this.itemIndex >= this.inventory.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return this.inventory.getItem(this.itemIndex);
    }

    public void setQuickMoveConsumer(Consumer<ItemStack> consumer) {
        this.quickMoveConsumer = consumer;
    }

    @Override
    public void HandleMessage(LazyPacketData message) {
        if (message.contains("MoveToSlot")) {
            this.quickMoveConsumer.accept(message.getItem("MoveToSlot"));
        }
        if (message.contains("AddEntry")) {
            this.editData(filter -> filter.addEntry(message.getResourceLocation("AddEntry")));
        }
        if (message.contains("RemoveEntry")) {
            this.editData(filter -> filter.removeEntry(message.getResourceLocation("RemoveEntry")));
        }
        if (message.contains("AddTag")) {
            this.editData(filter -> filter.addTag(message.getResourceLocation("AddTag")));
        }
        if (message.contains("RemoveTag")) {
            this.editData(filter -> filter.removeTag(message.getResourceLocation("RemoveTag")));
        }
    }

    protected final void editData(UnaryOperator<FilterData> action) {
        ItemStack target = this.getTargetedStack();
        if (target.isEmpty()) {
            this.player.closeContainer();
        } else {
            FilterData filter = (FilterData)target.getOrDefault(ModDataComponents.FILTER_DATA, (Object)FilterData.EMPTY);
            FilterData newFilter = (FilterData)action.apply(filter);
            if (newFilter.equals(filter)) {
                return;
            }
            target.set(ModDataComponents.FILTER_DATA, (Object)newFilter);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack quickMove;
        if (this.isClient()) {
            return ItemStack.EMPTY;
        }
        if (index >= 0 && index < this.slots.size() && !(quickMove = ((Slot)this.slots.get(index)).getItem()).isEmpty()) {
            this.SendMessage(this.builder().setItem("MoveToSlot", quickMove));
        }
        return ItemStack.EMPTY;
    }

    public static void OpenMenu(Player player, int itemIndex) {
        player.openMenu((MenuProvider)new Provider(itemIndex), buf -> buf.writeInt(itemIndex));
    }

    private record Provider(int itemIndex) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
            return new ItemFilterMenu(containerId, inventory, this.itemIndex);
        }
    }
}

