/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.common.config.VillagerTradeModsOption;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.ConfiguredTradeMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VillagerTradeMods {
    private final Map<String, ConfiguredTradeMod> modMap;

    public final Map<String, ConfiguredTradeMod> getModMap() {
        return this.modMap;
    }

    public int getSize() {
        return this.modMap.size();
    }

    private VillagerTradeMods(Builder builder) {
        HashMap temp = new HashMap();
        builder.dataMap.forEach((key, subBuilder) -> temp.put(key, subBuilder.build(false)));
        this.modMap = ImmutableMap.copyOf(temp);
    }

    public VillagerTradeMods(Map<String, ConfiguredTradeMod> map) {
        this.modMap = ImmutableMap.copyOf(map);
    }

    public VillagerTradeMods(List<String> parseableData) {
        HashMap<String, ConfiguredTradeMod> temp = new HashMap<String, ConfiguredTradeMod>();
        for (String data : parseableData) {
            try {
                Pair<String, ConfiguredTradeMod> results = this.tryParseEntry(data);
                if (temp.containsKey(results.getFirst())) {
                    throw new ConfigParsingException("Duplicate profession type '" + (String)results.getFirst() + "' modded!");
                }
                temp.put((String)results.getFirst(), (ConfiguredTradeMod)results.getSecond());
            }
            catch (ConfigParsingException e) {
                LightmansCurrency.LogError("Error parsing '" + data + "' as a villager trade modification.", e);
            }
        }
        this.modMap = ImmutableMap.copyOf(temp);
    }

    public final List<String> writeToConfig() {
        ArrayList<String> data = new ArrayList<String>();
        this.modMap.forEach((key, entry) -> {
            StringBuilder builder = new StringBuilder((String)key).append("-");
            entry.write(builder);
            data.add(builder.toString());
        });
        return data;
    }

    private Pair<String, ConfiguredTradeMod> tryParseEntry(String entry) throws ConfigParsingException {
        String[] split = entry.split("-", 2);
        if (split.length < 2) {
            throw new ConfigParsingException("Missing '-' dividers!");
        }
        String profession = split[0];
        LightmansCurrency.LogDebug("Attempting to parse entries for '" + profession + "' profession.");
        ConfiguredTradeMod mod = ConfiguredTradeMod.tryParse(split[1], false);
        return Pair.of((Object)profession, (Object)mod);
    }

    public VillagerTradeMods edit(String value, String key, boolean isSet) throws ConfigParsingException {
        if (isSet) {
            ConfiguredTradeMod mod = ConfiguredTradeMod.tryParse(value, false);
            HashMap<String, ConfiguredTradeMod> map = new HashMap<String, ConfiguredTradeMod>(this.modMap);
            map.put(key, mod);
            return new VillagerTradeMods(map);
        }
        if (this.modMap.containsKey(key)) {
            HashMap<String, ConfiguredTradeMod> map = new HashMap<String, ConfiguredTradeMod>(this.modMap);
            this.modMap.remove(key);
            return new VillagerTradeMods(map);
        }
        throw new ConfigParsingException("Cannot remove the entry for the \"" + key + "\" profession as is is not present.");
    }

    public final ConfiguredTradeMod getModFor(String trader) {
        if (this.modMap.containsKey(trader)) {
            return this.modMap.get(trader);
        }
        return (ConfiguredTradeMod)LCConfig.COMMON.defaultEmeraldReplacementMod.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, ConfiguredTradeMod.ModBuilder> dataMap = new HashMap<String, ConfiguredTradeMod.ModBuilder>();

        private Builder() {
        }

        public ConfiguredTradeMod.ModBuilder forProfession(VillagerProfession profession) {
            return this.forProfession(BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession));
        }

        public ConfiguredTradeMod.ModBuilder forProfession(ResourceLocation profession) {
            return this.forProfession(profession.toString());
        }

        public ConfiguredTradeMod.ModBuilder forProfession(String profession) {
            if (!this.dataMap.containsKey(profession)) {
                this.dataMap.put(profession, ConfiguredTradeMod.builder(this));
            }
            return this.dataMap.get(profession);
        }

        public VillagerTradeMods build() {
            return new VillagerTradeMods(this);
        }

        public VillagerTradeModsOption buildOption() {
            return VillagerTradeModsOption.create(this::build);
        }
    }
}

