/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IDynamicLuaObject;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.lua.ObjectArguments;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.events.PeripheralMethodsEvent;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.InventoryPeripheral;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class LCPeripheral
implements IDynamicPeripheral {
    protected final AttachedComputerSet computers = new AttachedComputerSet();
    private List<LCPeripheralMethod> methods = null;

    protected final HolderLookup.Provider registryAccess() {
        return LookupHelper.getRegistryAccess();
    }

    public List<String> getTypeList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.getType());
        types.addAll(this.getAdditionalTypes());
        return types;
    }

    private String[] getTypes() {
        return (String[])this.getTypeList().toArray(String[]::new);
    }

    private boolean isTypeArg(IArguments args) throws LuaException {
        return this.isType(args.getString(0));
    }

    public boolean isType(String queryType) {
        return this.getTypeList().contains(queryType);
    }

    public final void attach(IComputerAccess computer) {
        boolean wasEmpty = !this.computers.hasComputers();
        this.computers.add(computer);
        this.onAttachment(computer);
        if (wasEmpty) {
            this.onFirstAttachment();
        }
    }

    protected void onAttachment(IComputerAccess computer) {
    }

    protected void onFirstAttachment() {
    }

    public final void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        this.onDetachment(computer);
        if (!this.computers.hasComputers()) {
            this.onLastDetachment();
        }
    }

    protected void onLastDetachment() {
    }

    protected void onDetachment(IComputerAccess computer) {
    }

    protected abstract void registerMethods(LCPeripheralMethod.Registration var1);

    private void validateMethods() {
        if (this.methods == null) {
            LCPeripheralMethod.Registration registration = new LCPeripheralMethod.Registration();
            registration.register(LCPeripheralMethod.builder("getType").simple(() -> ((LCPeripheral)this).getType()));
            registration.register(LCPeripheralMethod.builder("getTypes").simpleArray(this::getTypes));
            registration.register(LCPeripheralMethod.builder("isType").withArgs(this::isTypeArg));
            this.registerMethods(registration);
            VersionUtil.postEvent(new PeripheralMethodsEvent(this, registration));
            this.methods = registration.getResults();
        }
    }

    private List<LCPeripheralMethod> getMethods() {
        this.validateMethods();
        return this.methods.stream().filter(LCPeripheralMethod::isAccessible).toList();
    }

    public final String[] getMethodNames() {
        return (String[])this.getMethods().stream().map(LCPeripheralMethod::getMethodName).toArray(String[]::new);
    }

    public final MethodResult callMethod(IComputerAccess computer, ILuaContext context, int methodIndex, IArguments args) throws LuaException {
        this.validateMethods();
        LCPeripheralMethod m = this.getMethods().get(methodIndex);
        ObjectArguments argumentCopy = new ObjectArguments(args.getAll());
        return context.executeMainThreadTask(() -> LCPeripheral.lambda$callMethod$2(m, computer, (IArguments)argumentCopy));
    }

    public static Object wrapContainer(IComputerAccess computer, Supplier<Boolean> canAccess, Container container) {
        return new InventoryPeripheral(canAccess, (IItemHandler)new InvWrapper(container)).asTable(computer);
    }

    public static Object wrapContainer(IComputerAccess computer, Supplier<Boolean> canAccess, Supplier<Container> container) {
        return new InventoryPeripheral(canAccess, (IItemHandler)new InvWrapper((Container)new SuppliedContainer(container))).asTable(computer);
    }

    public static Object wrapInventory(IComputerAccess computer, Supplier<Boolean> canAccess, IItemHandler handler) {
        return new InventoryPeripheral(canAccess, handler).asTable(computer);
    }

    public static Object wrapInventory(IComputerAccess computer, Supplier<Boolean> canAccess, Supplier<IItemHandler> handler) {
        return new InventoryPeripheral(canAccess, handler).asTable(computer);
    }

    public final Object asTable(IComputerAccess computer) {
        return new LCPeripheralWrapper(this, computer);
    }

    private static /* synthetic */ Object[] lambda$callMethod$2(LCPeripheralMethod m, IComputerAccess computer, IArguments argumentCopy) throws LuaException {
        return m.execute(computer, argumentCopy);
    }

    private record LCPeripheralWrapper(LCPeripheral peripheral, IComputerAccess computer) implements IDynamicLuaObject
    {
        public String[] getMethodNames() {
            return this.peripheral.getMethodNames();
        }

        public MethodResult callMethod(ILuaContext context, int index, IArguments args) throws LuaException {
            return this.peripheral.callMethod(this.computer, context, index, args);
        }
    }
}

