/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.slot_machine;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.util.ArgumentHelpers;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.SlotMachineTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCArgumentHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.slot_machine.SlotMachineEntryWrapper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.neoforged.neoforge.items.IItemHandler;

public class SlotMachinePeripheral
extends TraderPeripheral<SlotMachineTraderBlockEntity, SlotMachineTraderData> {
    public SlotMachinePeripheral(SlotMachineTraderData trader) {
        super(trader);
    }

    public SlotMachinePeripheral(SlotMachineTraderBlockEntity slotMachineTraderBlockEntity) {
        super(slotMachineTraderBlockEntity);
    }

    @Override
    @Nullable
    protected LCPeripheral wrapTrade(TradeData trade) {
        return this;
    }

    public String getType() {
        return "lc_trader_slot_machine";
    }

    public int getStorageStackLimit() throws LuaException {
        return ((SlotMachineTraderData)this.getTrader()).getStorageStackLimit();
    }

    public Object getStorage(IComputerAccess computer) {
        return SlotMachinePeripheral.wrapInventory(computer, () -> this.hasPermissions(computer, "openStorage"), this::safeGetStorage);
    }

    private IItemHandler safeGetStorage() {
        SlotMachineTraderData trader = (SlotMachineTraderData)this.safeGetTrader();
        if (trader != null) {
            return trader.getStorage();
        }
        return null;
    }

    public LCLuaTable getPrice() throws LuaException {
        return LCLuaTable.fromMoney(((SlotMachineTraderData)this.getTrader()).getPrice());
    }

    public boolean setPrice(IComputerAccess computer, IArguments args) throws LuaException {
        MoneyValue newPrice = LCArgumentHelper.parseMoneyValue(args, 0, true);
        SlotMachineTraderData trader = (SlotMachineTraderData)this.getTrader();
        if (this.hasPermissions(computer, "editTrades")) {
            trader.setPrice(newPrice);
            return true;
        }
        return false;
    }

    public int getEntryCount() throws LuaException {
        return ((SlotMachineTraderData)this.getTrader()).getAllEntries().size();
    }

    public int getValidEntryCount() throws LuaException {
        return ((SlotMachineTraderData)this.getTrader()).getValidEntries().size();
    }

    public Object getEntry(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        SlotMachineTraderData trader = (SlotMachineTraderData)this.getTrader();
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)trader.getAllEntries().size(), (String)"Entry Slot is out of bounds (%s)");
        return this.wrapEntry(slot - 1).asTable(computer);
    }

    public double getFailOdds() throws LuaException {
        return ((SlotMachineTraderData)this.getTrader()).getFailOdds();
    }

    private SlotMachineEntryWrapper wrapEntry(int index) {
        return new SlotMachineEntryWrapper(this.entrySource(index), this::safeGetTrader);
    }

    private Supplier<SlotMachineEntry> entrySource(int index) {
        return () -> {
            SlotMachineTraderData trader = (SlotMachineTraderData)this.safeGetTrader();
            if (trader != null) {
                List<SlotMachineEntry> entry = trader.getAllEntries();
                if (index >= 0 && index < entry.size()) {
                    return entry.get(index);
                }
            }
            return null;
        };
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        super.registerMethods(registration);
        registration.register(LCPeripheralMethod.builder("getStorageStackLimit").simple(this::getStorageStackLimit));
        registration.register(LCPeripheralMethod.builder("getStorage").withContextOnly(this::getStorage));
        registration.register(LCPeripheralMethod.builder("getPrice").simple(this::getPrice));
        registration.register(LCPeripheralMethod.builder("setPrice").withContext(this::setPrice));
        registration.register(LCPeripheralMethod.builder("getEntryCount").simple(this::getEntryCount));
        registration.register(LCPeripheralMethod.builder("getValidEntryCount").simple(this::getValidEntryCount));
        registration.register(LCPeripheralMethod.builder("getEntry").withContext(this::getEntry));
        registration.register(LCPeripheralMethod.builder("getFailOdds").simple(this::getFailOdds));
    }
}

