/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.command;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketSyncAdminList
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketSyncAdminList> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_sync_admin_list"));
    public static final CustomPacket.Handler<SPacketSyncAdminList> HANDLER = new H();
    List<UUID> adminList;

    public SPacketSyncAdminList(List<UUID> adminList) {
        super(TYPE);
        this.adminList = adminList;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketSyncAdminList message) {
        buffer.writeInt(message.adminList.size());
        for (UUID id : message.adminList) {
            buffer.writeUUID(id);
        }
    }

    private static SPacketSyncAdminList decode(@Nonnull FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (int i = 0; i < count; ++i) {
            result.add(buffer.readUUID());
        }
        return new SPacketSyncAdminList(result);
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncAdminList> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketSyncAdminList::encode, SPacketSyncAdminList::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketSyncAdminList message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            LightmansCurrency.getProxy().loadAdminPlayers(message.adminList);
        }
    }
}

