/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import dev.obscuria.lootjournal.client.render.Anchor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public enum Style {
    CLASSIC(Style::renderClassic),
    FLAT(Style::renderFlat),
    TEXT(Style::renderText);

    private static final ResourceLocation DECORATIONS;
    private final Renderer renderer;

    private Style(Renderer renderer) {
        this.renderer = renderer;
    }

    public void render(IPickup pickup, GuiGraphics graphics, Anchor anchor, int x, int y, double ratio, long time) {
        Font font = Minecraft.getInstance().font;
        double actualX = (double)x + Style.getOffset(ratio, anchor.isReversed());
        MutableComponent name = pickup.getDisplayName();
        int nameWidth = font.width((FormattedText)name);
        MutableComponent total = pickup.shouldDisplayTotal() ? Component.literal((String)String.valueOf(pickup.getTotal())) : Component.empty();
        int totalWidth = pickup.shouldDisplayTotal() ? font.width((FormattedText)total) + 5 : 0;
        graphics.pose().pushPose();
        graphics.pose().translate(actualX, (double)y, 400.0);
        RenderSystem.enableBlend();
        this.renderer.render(pickup, graphics, anchor, font, name, nameWidth, total, totalWidth, actualX, y, time);
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    private static void renderClassic(IPickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.blit(DECORATIONS, -36 - nameWidth - totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.blit(DECORATIONS, -26 - totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.drawString(font, (Component)name, -29 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.blit(DECORATIONS, -218 + nameWidth + totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.blit(DECORATIONS, -230 + totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.drawString(font, (Component)name, 30 + totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderFlat(IPickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.fill(-3, 0, -25 - nameWidth - totalWidth, 12, Integer.MIN_VALUE);
            graphics.drawString(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.fill(3, 0, 25 + nameWidth + totalWidth, 12, Integer.MIN_VALUE);
            graphics.drawString(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderText(IPickup pickup, GuiGraphics graphics, Anchor anchor, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.drawString(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.drawString(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.drawString(font, (Component)total.withStyle(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderIcon(IPickup pickup, GuiGraphics graphics, double x, double y, long time) {
        graphics.pose().pushPose();
        graphics.pose().translate(x, y, 0.0);
        pickup.renderIcon(graphics, time);
        graphics.pose().popPose();
    }

    private static Component getName(String raw, int count) {
        if (((String)raw).length() > 24) {
            raw = ((String)raw).substring(0, 23) + "...";
        }
        return Component.literal((String)((String)raw + " x" + count));
    }

    private static double getOffset(double factor, boolean inverted) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(factor - 1.0, 2.0));
        return inverted ? -offset : offset;
    }

    static {
        DECORATIONS = LootJournal.key("textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface Renderer {
        public void render(IPickup var1, GuiGraphics var2, Anchor var3, Font var4, MutableComponent var5, int var6, MutableComponent var7, int var8, double var9, double var11, long var13);
    }
}

