/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.neoforge;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.ModConfig;
import dev.obscuria.lootjournal.client.DefaultBehavior;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.List;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.compress.utils.Lists;

public final class NeoConfig {
    private static final ModConfigSpec SPEC;
    private static final ModConfigSpec.EnumValue<Style> STYLE;
    private static final ModConfigSpec.BooleanValue USE_RARITY_COLOR;
    private static final ModConfigSpec.ConfigValue<String> ITEMS_COLOR;
    private static final ModConfigSpec.ConfigValue<String> GROUPED_ITEMS_COLOR;
    private static final ModConfigSpec.ConfigValue<String> EXPERIENCE_COLOR;
    private static final ModConfigSpec.BooleanValue DISPLAY_EXPERIENCE;
    private static final ModConfigSpec.BooleanValue DISPLAY_TOTAL;
    private static final ModConfigSpec.EnumValue<Anchor> ANCHOR;
    private static final ModConfigSpec.IntValue ANCHOR_OFFSET;
    private static final ModConfigSpec.IntValue NOTIFICATION_SEPARATION;
    private static final ModConfigSpec.IntValue NOTIFICATION_LIFETIME;
    private static final ModConfigSpec.IntValue MAX_VISIBLE_NOTIFICATIONS;
    private static final ModConfigSpec.IntValue MAX_QUEUED_NOTIFICATIONS;
    private static final ModConfigSpec.EnumValue<DefaultBehavior> DEFAULT_BEHAVIOR;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> TABS_BLACKLIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ITEMS_BLACKLIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> TABS_WHITELIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ITEMS_WHITELIST;

    public static void init(IEventBus eventBus, ModContainer container) {
        eventBus.addListener(NeoConfig::onUpdate);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "obscuria/loot_journal-client.toml");
    }

    public static void onUpdate(ModConfigEvent event) {
        LootJournal.CONFIG.style = (Style)((Object)STYLE.get());
        LootJournal.CONFIG.useRarityColor = (Boolean)USE_RARITY_COLOR.get();
        LootJournal.CONFIG.itemsColor = ModConfig.hexToInt((String)ITEMS_COLOR.get());
        LootJournal.CONFIG.groupedItemsColor = ModConfig.hexToInt((String)GROUPED_ITEMS_COLOR.get());
        LootJournal.CONFIG.experienceColor = ModConfig.hexToInt((String)EXPERIENCE_COLOR.get());
        LootJournal.CONFIG.displayExperience = (Boolean)DISPLAY_EXPERIENCE.get();
        LootJournal.CONFIG.displayTotal = (Boolean)DISPLAY_TOTAL.get();
        LootJournal.CONFIG.anchor = (Anchor)((Object)ANCHOR.get());
        LootJournal.CONFIG.anchorOffset = (Integer)ANCHOR_OFFSET.get();
        LootJournal.CONFIG.notificationSeparation = (Integer)NOTIFICATION_SEPARATION.get();
        LootJournal.CONFIG.notificationLifetime = ((Integer)NOTIFICATION_LIFETIME.get()).intValue();
        LootJournal.CONFIG.maxVisibleNotifications = (Integer)MAX_VISIBLE_NOTIFICATIONS.get();
        LootJournal.CONFIG.maxQueuedNotifications = (Integer)MAX_QUEUED_NOTIFICATIONS.get();
        LootJournal.CONFIG.defaultBehavior = (DefaultBehavior)((Object)DEFAULT_BEHAVIOR.get());
        LootJournal.CONFIG.tabsBlacklist = ModConfig.mapTabs((List)TABS_BLACKLIST.get());
        LootJournal.CONFIG.itemsBlacklist = ModConfig.mapItems((List)ITEMS_BLACKLIST.get());
        LootJournal.CONFIG.tabsWhitelist = ModConfig.mapTabs((List)TABS_WHITELIST.get());
        LootJournal.CONFIG.itemsWhitelist = ModConfig.mapItems((List)ITEMS_WHITELIST.get());
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Display");
        STYLE = builder.defineEnum("style", (Enum)ModConfig.STYLE);
        USE_RARITY_COLOR = builder.define("useRarityColor", true);
        ITEMS_COLOR = builder.define("itemsColor", (Object)ModConfig.intToHex(0xFFFFFF));
        GROUPED_ITEMS_COLOR = builder.define("groupedItemsColor", (Object)ModConfig.intToHex(0xFFFFFF));
        EXPERIENCE_COLOR = builder.define("experienceColor", (Object)ModConfig.intToHex(0x55FF55));
        DISPLAY_EXPERIENCE = builder.define("displayExperience", true);
        DISPLAY_TOTAL = builder.define("displayTotal", true);
        builder.pop();
        builder.push("Positioning");
        ANCHOR = builder.defineEnum("anchor", (Enum)ModConfig.ANCHOR);
        ANCHOR_OFFSET = builder.defineInRange("anchorOffset", 3, 0, 256);
        NOTIFICATION_SEPARATION = builder.defineInRange("notificationSeparation", 3, 0, 16);
        NOTIFICATION_LIFETIME = builder.defineInRange("notificationLifetime", 6, 0, 32);
        MAX_VISIBLE_NOTIFICATIONS = builder.defineInRange("maxVisibleNotifications", 12, 1, 64);
        MAX_QUEUED_NOTIFICATIONS = builder.defineInRange("maxQueuedNotifications", 23, 0, 256);
        builder.pop();
        builder.push("Filtering");
        DEFAULT_BEHAVIOR = builder.defineEnum("defaultBehavior", (Enum)ModConfig.DEFAULT_BEHAVIOR);
        TABS_BLACKLIST = builder.defineList("tabsBlacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        ITEMS_BLACKLIST = builder.defineList("itemsBlacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        TABS_WHITELIST = builder.defineList("tabsWhitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        ITEMS_WHITELIST = builder.defineList("itemsWhitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

