/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core;

import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.util.NullableFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;

public class LootBucket
implements Iterable<ItemStack> {
    private final LootContext context;
    private final List<ItemStack> loot;

    public LootBucket(LootContext context) {
        this(context, new ArrayList<ItemStack>());
    }

    public LootBucket(LootContext context, List<ItemStack> loot) {
        this.context = context;
        this.loot = loot;
    }

    public void addItem(ItemStack item) {
        this.loot.add(item);
    }

    public void addAllItems(List<ItemStack> items) {
        for (ItemStack item : items) {
            this.addItem(item);
        }
    }

    public void addEntry(LootEntry unknown) {
        unknown.getVanillaEntry().expand(this.context, this::addEntry);
    }

    private void addEntry(LootPoolEntry entry) {
        entry.createItemStack(this::addItem, this.context);
    }

    public void remove(ItemFilter removeFilter) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ItemStack itemStack = (ItemStack)it.next();
            if (!removeFilter.test(itemStack)) continue;
            it.remove();
        }
    }

    public void clear() {
        this.remove(ItemFilter.ANY);
    }

    public boolean hasItem(ItemFilter filter) {
        for (ItemStack itemStack : this) {
            if (!filter.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void modifyItems(NullableFunction<ItemStack, ItemStack> function) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ItemStack result = function.apply((ItemStack)it.next());
            if (result == null) {
                it.remove();
                continue;
            }
            it.set(result);
        }
    }

    public void replace(ItemFilter filter, ItemLootEntry itemLootEntry) {
        this.replace(filter, itemLootEntry, false);
    }

    public void replace(ItemFilter filter, ItemLootEntry itemLootEntry, boolean preserveCount) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ItemStack newItem;
            ItemStack thisItem = (ItemStack)it.next();
            if (!filter.test(thisItem) || (newItem = itemLootEntry.create(this.context)) == null) continue;
            if (newItem.isEmpty()) {
                it.remove();
                continue;
            }
            if (preserveCount) {
                newItem.setCount(Math.min(thisItem.getCount(), newItem.getMaxStackSize()));
            }
            it.set(newItem);
        }
    }

    public LootBucket extract(ItemFilter filter) {
        ArrayList<ItemStack> extracted = new ArrayList<ItemStack>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ItemStack itemStack = (ItemStack)it.next();
            if (!filter.test(itemStack)) continue;
            extracted.add(itemStack);
            it.remove();
        }
        return new LootBucket(this.context, extracted);
    }

    public void merge(LootBucket other) {
        this.addAllItems(other.loot);
    }

    public ItemStack get(int index) {
        if (index < 0 || index >= this.loot.size()) {
            return ItemStack.EMPTY;
        }
        return this.loot.get(index);
    }

    public int size() {
        return this.loot.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        return this.loot.listIterator();
    }
}

