/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.api.ITabExpander;
import mcjty.lib.blocks.RBlockRegistry;
import mcjty.lib.tileentity.AnnotationHolder;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultModSetup {
    private Logger logger;
    protected CreativeModeTab creativeTab;
    private List<Supplier<ItemStack>> tabItems = new ArrayList<Supplier<ItemStack>>();

    public void init(FMLCommonSetupEvent e) {
        this.logger = LogManager.getLogger();
        this.setupModCompat();
    }

    protected abstract void setupModCompat();

    public void populateTab(CreativeModeTab.Output output) {
        this.tabItems.forEach(s -> {
            ITabExpander expander;
            List<ItemStack> itemsForTab;
            boolean todo = true;
            ItemStack st = (ItemStack)s.get();
            Item patt0$temp = st.getItem();
            if (patt0$temp instanceof ITabExpander && !(itemsForTab = (expander = (ITabExpander)patt0$temp).getItemsForTab()).isEmpty()) {
                todo = false;
                itemsForTab.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            }
            if (todo) {
                output.accept(st);
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Item.Properties defaultProperties() {
        return new Item.Properties();
    }

    public CreativeModeTab getTab() {
        return this.creativeTab;
    }

    public void addTabItem(Supplier<ItemStack> item) {
        this.tabItems.add(item);
    }

    public <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        Lazy lazyItem = Lazy.of(supplier);
        this.tabItems.add(() -> new ItemStack((ItemLike)lazyItem.get()));
        return lazyItem;
    }

    public Consumer<RegisterCapabilitiesEvent> getBlockCapabilityRegistrar(RBlockRegistry registry) {
        return event -> {
            for (AnnotationHolder holder : registry.getHolders()) {
                for (int i = 0; i < holder.getCapSize(); ++i) {
                    AnnotationHolder.CapHolder hd = holder.getCapHolder(i);
                    BlockCapability bc = hd.capability();
                    final Function<GenericTileEntity, Object> function = hd.function();
                    event.registerBlock(bc, (IBlockCapabilityProvider)new IBlockCapabilityProvider<Object, Object>(this){

                        @Nullable
                        public Object getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Object o) {
                            if (blockEntity instanceof GenericTileEntity) {
                                GenericTileEntity be = (GenericTileEntity)blockEntity;
                                return function.apply(be);
                            }
                            return null;
                        }
                    }, new Block[]{(Block)hd.block().get()});
                }
            }
        };
    }
}

