/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfences.kikoz.objects;

import com.mcwfences.kikoz.objects.DoubleGate;
import com.mcwfences.kikoz.objects.FenceHitbox;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalFence
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final EnumProperty<FencePart> PART = EnumProperty.create((String)"fencepart", FencePart.class, (Enum[])new FencePart[]{FencePart.TOP, FencePart.BOTTOM});
    private static final VoxelShape POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    private static final VoxelShape POST_COLLISION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE_COLLISION = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE_COLLISION = Block.box((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)24.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE_COLLISION = Block.box((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE_COLLISION = Block.box((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)24.0, (double)10.0);
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLLISION_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();

    public MetalFence(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)FencePart.TOP)));
    }

    private BlockState FenceState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        return (BlockState)state.setValue(PART, (Comparable)((Object)connection));
    }

    private FencePart getConnectionStatus(boolean above, boolean below) {
        if (!above) {
            return FencePart.TOP;
        }
        return FencePart.BOTTOM;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.FenceState(state, (LevelAccessor)level, pos);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState northState = level.getBlockState(pos.north());
        BlockState southState = level.getBlockState(pos.south());
        BlockState eastState = level.getBlockState(pos.east());
        BlockState westState = level.getBlockState(pos.west());
        boolean northConnects = this.canConnect(northState, northState.isFaceSturdy((BlockGetter)level, pos.north(), Direction.SOUTH), Direction.SOUTH);
        boolean southConnects = this.canConnect(southState, southState.isFaceSturdy((BlockGetter)level, pos.south(), Direction.NORTH), Direction.NORTH);
        boolean eastConnects = this.canConnect(eastState, eastState.isFaceSturdy((BlockGetter)level, pos.east(), Direction.WEST), Direction.WEST);
        boolean westConnects = this.canConnect(westState, westState.isFaceSturdy((BlockGetter)level, pos.west(), Direction.EAST), Direction.EAST);
        return this.FenceState((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)NORTH, (Comparable)Boolean.valueOf(northConnects))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(southConnects))).setValue((Property)EAST, (Comparable)Boolean.valueOf(eastConnects))).setValue((Property)WEST, (Comparable)Boolean.valueOf(westConnects)), (LevelAccessor)level, pos);
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_CACHE.computeIfAbsent(state, this::computeShape);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE_CACHE.computeIfAbsent(state, this::computeCollision);
    }

    private VoxelShape computeShape(BlockState state) {
        VoxelShape shape = POST;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        return shape;
    }

    private VoxelShape computeCollision(BlockState state) {
        VoxelShape shape = POST_COLLISION;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE_COLLISION);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE_COLLISION);
        }
        return shape;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty property;
        if (direction.getAxis().isHorizontal() && (property = this.getProperty(direction)) != null) {
            boolean isNeighborSturdy = neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction.getOpposite());
            boolean connects = neighborState.isAir() ? false : this.canConnect(neighborState, isNeighborSturdy, direction);
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(connects));
        }
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        state = (BlockState)state.setValue(PART, (Comparable)((Object)connection));
        return state;
    }

    public boolean canConnect(BlockState state, boolean bool, Direction dir) {
        Block block = state.getBlock();
        boolean flag = this.isSameFence(state);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)state, (Direction)dir);
        boolean flag2 = block instanceof WallBlock;
        boolean flag3 = block instanceof FenceHitbox;
        boolean flag4 = block instanceof DoubleGate;
        boolean flag5 = block instanceof FenceGateBlock;
        boolean flag6 = block instanceof FenceBlock;
        return !MetalFence.isExceptionForConnection((BlockState)state) && bool || flag || flag1 || flag2 || flag3 || flag4 || flag5 || flag6;
    }

    private boolean isSameFence(BlockState state) {
        return state.is(BlockTags.FENCES) && state.is(BlockTags.WOODEN_FENCES) == this.defaultBlockState().is(BlockTags.WOODEN_FENCES);
    }

    private BooleanProperty getProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> null;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, PART});
    }

    public static enum FencePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private FencePart(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

