/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.rule;

import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;

public class MobEx
implements Serializable {
    private final String name;
    private final String namespace;
    private final String path;
    EntityType<?> entityType = null;
    public ArrayList<MobExRule> rules = new ArrayList();

    public MobEx(String name) {
        if (name.contains(":")) {
            String[] parts = name.split(":");
            this.namespace = parts[0].trim().toLowerCase();
            this.path = parts[1].trim().toLowerCase();
        } else {
            this.namespace = name.trim().toLowerCase();
            this.path = "*";
        }
        this.name = this.namespace + ":" + this.path;
    }

    public static int randomFromRange(int from, int to) {
        if (from == to) {
            return from;
        }
        return Util.random.nextInt(from, to);
    }

    public static boolean can(Integer check) {
        if (check == null) {
            return false;
        }
        if (check > 99) {
            return true;
        }
        return check > 0 && Util.random.nextInt(100) <= check;
    }

    public String name() {
        return this.name;
    }

    public EntityType<?> entityType() {
        if (this.entityType == null && !this.isWild()) {
            Optional optional = EntityType.byString((String)this.name);
            optional.ifPresent(entityType -> {
                this.entityType = entityType;
            });
        }
        return this.entityType;
    }

    public boolean isWild() {
        return this.namespace.contains("*") || this.path.contains("*");
    }
}

