/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.iface.IValueReader;
import java.util.concurrent.atomic.AtomicInteger;

public class LiteralStringValueReader
implements IValueReader {
    static final LiteralStringValueReader LITERAL_STRING_VALUE_READER = new LiteralStringValueReader();

    @Override
    public boolean canRead(String string) {
        return string.startsWith("'");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        int startLine = context.line.get();
        boolean terminated = false;
        int startIndex = atomicInteger.incrementAndGet();
        int index = atomicInteger.get();
        while (index < string.length()) {
            if (string.charAt(index) == '\'') {
                terminated = true;
                break;
            }
            index = atomicInteger.incrementAndGet();
        }
        if (!terminated) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), string.substring(startIndex), startLine);
            return errors;
        }
        return string.substring(startIndex, atomicInteger.get());
    }
}

