/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class BookTextPageRenderer
extends BookPageRenderer<BookTextPage>
implements PageWithTextRenderer {
    public BookTextPageRenderer(BookTextPage page) {
        super(page);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        if (((BookTextPage)this.page).hasTitle()) {
            this.renderTitle(guiGraphics, ((BookTextPage)this.page).getTitle(), ((BookTextPage)this.page).showTitleSeparator(), 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookTextPage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (((BookTextPage)this.page).hasTitle() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookTextPage)this.page).getTitle(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookTextPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        if (((BookTextPage)this.page).hasTitle()) {
            return ((BookTextPage)this.page).showTitleSeparator() ? 17 : 7;
        }
        return -4;
    }
}

