/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Function;
import net.favouriteless.modopedia.api.datagen.BookContentBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public abstract class PageComponentBuilder
implements BookContentBuilder {
    private final ResourceLocation type;
    private final boolean isTemplate;
    private Either<Integer, String> x;
    private Either<Integer, String> y;

    protected PageComponentBuilder(ResourceLocation type, boolean isTemplate) {
        this.type = type;
        this.isTemplate = isTemplate;
    }

    protected PageComponentBuilder(ResourceLocation type) {
        this(type, false);
    }

    protected abstract void build(JsonObject var1, RegistryOps<JsonElement> var2);

    public PageComponentBuilder x(int x) {
        this.x = Either.left((Object)x);
        return this;
    }

    public PageComponentBuilder x(String x) {
        this.x = Either.right((Object)x);
        return this;
    }

    public PageComponentBuilder y(int y) {
        this.y = Either.left((Object)y);
        return this;
    }

    public PageComponentBuilder y(String y) {
        this.y = Either.right((Object)y);
        return this;
    }

    @Override
    public final JsonElement build(RegistryOps<JsonElement> ops) {
        JsonObject json = new JsonObject();
        if (this.type != null) {
            json.add(this.isTemplate ? "template" : "type", (JsonElement)ResourceLocation.CODEC.encodeStart(ops, (Object)this.type).getOrThrow());
        }
        if (this.x != null) {
            json.add("x", this.resolveNum(this.x));
        }
        if (this.y != null) {
            json.add("y", this.resolveNum(this.y));
        }
        this.build(json, ops);
        return json;
    }

    protected <L> JsonElement resolve(Either<L, String> either, Function<L, JsonElement> serializer) {
        return (JsonElement)either.map(serializer, JsonPrimitive::new);
    }

    protected JsonElement resolveBool(Either<Boolean, String> either) {
        return (JsonElement)either.map(JsonPrimitive::new, JsonPrimitive::new);
    }

    protected JsonElement resolveNum(Either<? extends Number, String> either) {
        return (JsonElement)either.map(JsonPrimitive::new, JsonPrimitive::new);
    }

    protected JsonElement resolveString(Either<String, String> either) {
        return (JsonElement)either.map(JsonPrimitive::new, JsonPrimitive::new);
    }

    protected JsonElement resolveString(String string) {
        return new JsonPrimitive(string);
    }

    protected JsonElement resolveResourceLocation(Either<ResourceLocation, String> either) {
        return (JsonElement)either.map(l -> (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, l).getOrThrow(), JsonPrimitive::new);
    }
}

