/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.favouriteless.modopedia.api.datagen.builders.PageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class TemplateBuilder
extends PageBuilder {
    private final Map<String, Supplier<JsonElement>> defaults = new HashMap<String, Supplier<JsonElement>>();
    private ResourceLocation processor;

    private TemplateBuilder() {
    }

    public static TemplateBuilder of() {
        return new TemplateBuilder();
    }

    public TemplateBuilder processor(ResourceLocation processor) {
        this.processor = processor;
        return this;
    }

    @Override
    public TemplateBuilder components(PageComponentBuilder ... components) {
        return (TemplateBuilder)super.components(components);
    }

    public TemplateBuilder defaultValue(String key, Supplier<JsonElement> value) {
        this.defaults.put(key, value);
        return this;
    }

    public TemplateBuilder defaultValue(String key, Number number) {
        this.defaults.put(key, () -> new JsonPrimitive(number));
        return this;
    }

    public TemplateBuilder defaultValue(String key, String string) {
        this.defaults.put(key, () -> new JsonPrimitive(string));
        return this;
    }

    public TemplateBuilder defaultValue(String key, boolean string) {
        this.defaults.put(key, () -> new JsonPrimitive(Boolean.valueOf(string)));
        return this;
    }

    @Override
    public JsonElement build(RegistryOps<JsonElement> ops) {
        JsonObject json = super.build(ops).getAsJsonObject();
        if (this.processor != null) {
            json.add("processor", (JsonElement)ResourceLocation.CODEC.encodeStart(ops, (Object)this.processor).getOrThrow());
        }
        for (Map.Entry<String, Supplier<JsonElement>> entry : this.defaults.entrySet()) {
            json.add(entry.getKey(), entry.getValue().get());
        }
        return json;
    }
}

