/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.page_components.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.client.page_components.MultiblockPageComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class MultiblockBuilder
extends PageComponentBuilder {
    private Either<Multiblock, String> multiblock;
    private Either<ResourceLocation, String> multiblockId;
    private Either<Integer, String> width;
    private Either<Integer, String> height;
    private Either<Float, String> offsetX;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Float, String> viewAngle;
    private Either<Boolean, String> noOffsets;

    private MultiblockBuilder() {
        super(MultiblockPageComponent.ID);
    }

    public static MultiblockBuilder of() {
        return new MultiblockBuilder();
    }

    public MultiblockBuilder multiblock(Multiblock multiblock) {
        this.multiblock = Either.left((Object)multiblock);
        return this;
    }

    public MultiblockBuilder multiblock(String multiblock) {
        this.multiblock = Either.right((Object)multiblock);
        return this;
    }

    public MultiblockBuilder multiblockId(ResourceLocation multiblock) {
        this.multiblockId = Either.left((Object)multiblock);
        return this;
    }

    public MultiblockBuilder multiblockId(String multiblock) {
        this.multiblockId = Either.right((Object)multiblock);
        return this;
    }

    @Override
    public MultiblockBuilder x(int x) {
        return (MultiblockBuilder)super.x(x);
    }

    @Override
    public MultiblockBuilder x(String x) {
        return (MultiblockBuilder)super.x(x);
    }

    @Override
    public MultiblockBuilder y(int y) {
        return (MultiblockBuilder)super.y(y);
    }

    @Override
    public MultiblockBuilder y(String y) {
        return (MultiblockBuilder)super.y(y);
    }

    public MultiblockBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public MultiblockBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    public MultiblockBuilder offsetX(float offsetX) {
        this.offsetX = Either.left((Object)Float.valueOf(offsetX));
        return this;
    }

    public MultiblockBuilder offsetX(String offsetX) {
        this.offsetX = Either.right((Object)offsetX);
        return this;
    }

    public MultiblockBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public MultiblockBuilder offsetY(String offsetY) {
        this.offsetY = Either.right((Object)offsetY);
        return this;
    }

    public MultiblockBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public MultiblockBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public MultiblockBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public MultiblockBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    public MultiblockBuilder viewAngle(float viewAngle) {
        this.viewAngle = Either.left((Object)Float.valueOf(viewAngle));
        return this;
    }

    public MultiblockBuilder viewAngle(String viewAngle) {
        this.viewAngle = Either.right((Object)viewAngle);
        return this;
    }

    public MultiblockBuilder noOffsets(boolean noOffsets) {
        this.noOffsets = Either.left((Object)noOffsets);
        return this;
    }

    public MultiblockBuilder noOffsets(String noOffsets) {
        this.noOffsets = Either.right((Object)noOffsets);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        if (this.multiblock == null && this.multiblockId == null) {
            throw new IllegalStateException("MultiblockBuilder needs either a multiblock or multiblockId");
        }
        if (this.multiblock != null) {
            json.add("multiblock", this.resolve(this.multiblock, m -> (JsonElement)Multiblock.codec().encodeStart((DynamicOps)ops, m).getOrThrow()));
        }
        if (this.multiblockId != null) {
            json.add("multiblock_id", this.resolveResourceLocation(this.multiblockId));
        }
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
        if (this.offsetX != null) {
            json.add("offset_x", this.resolveNum(this.offsetX));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.viewAngle != null) {
            json.add("view_angle", this.resolveNum(this.viewAngle));
        }
        if (this.noOffsets != null) {
            json.add("no_offsets", this.resolveBool(this.noOffsets));
        }
    }
}

