/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.page_components.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.favouriteless.modopedia.client.page_components.ShowcasePageComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;

public class ShowcaseBuilder
extends PageComponentBuilder {
    private final Either<List<ItemStack>, String> items;
    private Either<Integer, String> width;
    private Either<Integer, String> height;
    private Either<Float, String> scale;

    private ShowcaseBuilder(ItemStack ... items) {
        super(ShowcasePageComponent.ID);
        this.items = Either.left(List.of(items));
    }

    private ShowcaseBuilder(String items) {
        super(ShowcasePageComponent.ID);
        this.items = Either.right((Object)items);
    }

    public static ShowcaseBuilder of(ItemStack ... items) {
        return new ShowcaseBuilder(items);
    }

    public static ShowcaseBuilder of(String items) {
        return new ShowcaseBuilder(items);
    }

    @Override
    public ShowcaseBuilder x(int x) {
        return (ShowcaseBuilder)super.x(x);
    }

    @Override
    public ShowcaseBuilder x(String x) {
        return (ShowcaseBuilder)super.x(x);
    }

    @Override
    public ShowcaseBuilder y(int y) {
        return (ShowcaseBuilder)super.y(y);
    }

    @Override
    public ShowcaseBuilder y(String y) {
        return (ShowcaseBuilder)super.y(y);
    }

    public ShowcaseBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public ShowcaseBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public ShowcaseBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public ShowcaseBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    public ShowcaseBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public ShowcaseBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("items", this.resolve(this.items, l -> (JsonElement)ItemStack.CODEC.listOf().encodeStart((DynamicOps)ops, l).getOrThrow()));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
    }
}

