/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class LargeFramedImageBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("large_framed_image");
    private final Either<List<ResourceLocation>, String> images;
    private Either<Integer, String> width;

    protected LargeFramedImageBuilder(ResourceLocation ... images) {
        super(ID);
        this.images = Either.left(List.of(images));
    }

    protected LargeFramedImageBuilder(String images) {
        super(ID);
        this.images = Either.right((Object)images);
    }

    public static LargeFramedImageBuilder of(ResourceLocation ... images) {
        return new LargeFramedImageBuilder(images);
    }

    public static LargeFramedImageBuilder of(String images) {
        return new LargeFramedImageBuilder(images);
    }

    @Override
    public LargeFramedImageBuilder x(int x) {
        return (LargeFramedImageBuilder)super.x(x);
    }

    @Override
    public LargeFramedImageBuilder x(String x) {
        return (LargeFramedImageBuilder)super.x(x);
    }

    @Override
    public LargeFramedImageBuilder y(int y) {
        return (LargeFramedImageBuilder)super.y(y);
    }

    @Override
    public LargeFramedImageBuilder y(String y) {
        return (LargeFramedImageBuilder)super.y(y);
    }

    public LargeFramedImageBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public LargeFramedImageBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("images", this.resolve(this.images, l -> (JsonElement)ResourceLocation.CODEC.listOf().encodeStart((DynamicOps)ops, l).getOrThrow()));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
    }
}

