/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LargeFramedShowcaseBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("large_framed_showcase");
    private final Either<List<ItemStack>, String> items;
    private Either<Integer, String> width;
    private Either<Float, String> scale;

    private LargeFramedShowcaseBuilder(ItemStack ... items) {
        super(ID);
        this.items = Either.left(List.of(items));
    }

    private LargeFramedShowcaseBuilder(String items) {
        super(ID);
        this.items = Either.right((Object)items);
    }

    public static LargeFramedShowcaseBuilder of(ItemStack ... items) {
        return new LargeFramedShowcaseBuilder(items);
    }

    public static LargeFramedShowcaseBuilder of(String type) {
        return new LargeFramedShowcaseBuilder(type);
    }

    @Override
    public LargeFramedShowcaseBuilder x(int x) {
        return (LargeFramedShowcaseBuilder)super.x(x);
    }

    @Override
    public LargeFramedShowcaseBuilder x(String x) {
        return (LargeFramedShowcaseBuilder)super.x(x);
    }

    @Override
    public LargeFramedShowcaseBuilder y(int y) {
        return (LargeFramedShowcaseBuilder)super.y(y);
    }

    @Override
    public LargeFramedShowcaseBuilder y(String y) {
        return (LargeFramedShowcaseBuilder)super.y(y);
    }

    public LargeFramedShowcaseBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public LargeFramedShowcaseBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public LargeFramedShowcaseBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public LargeFramedShowcaseBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("items", this.resolve(this.items, l -> (JsonElement)ItemStack.CODEC.listOf().encodeStart((DynamicOps)ops, l).getOrThrow()));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
    }
}

