/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class MediumFramedEntityBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("medium_framed_entity");
    private final Either<EntityType<?>, String> entity;
    private Either<CompoundTag, String> tag;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Integer, String> width;

    private MediumFramedEntityBuilder(EntityType<?> type) {
        super(ID);
        this.entity = Either.left(type);
    }

    private MediumFramedEntityBuilder(String type) {
        super(ID);
        this.entity = Either.right((Object)type);
    }

    public static MediumFramedEntityBuilder of(EntityType<?> type) {
        return new MediumFramedEntityBuilder(type);
    }

    public static MediumFramedEntityBuilder of(String type) {
        return new MediumFramedEntityBuilder(type);
    }

    @Override
    public MediumFramedEntityBuilder x(int x) {
        return (MediumFramedEntityBuilder)super.x(x);
    }

    @Override
    public MediumFramedEntityBuilder x(String x) {
        return (MediumFramedEntityBuilder)super.x(x);
    }

    @Override
    public MediumFramedEntityBuilder y(int y) {
        return (MediumFramedEntityBuilder)super.y(y);
    }

    @Override
    public MediumFramedEntityBuilder y(String y) {
        return (MediumFramedEntityBuilder)super.y(y);
    }

    public MediumFramedEntityBuilder tag(CompoundTag tag) {
        this.tag = Either.left((Object)tag);
        return this;
    }

    public MediumFramedEntityBuilder tag(String tag) {
        this.tag = Either.right((Object)tag);
        return this;
    }

    public MediumFramedEntityBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public MediumFramedEntityBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public MediumFramedEntityBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public MediumFramedEntityBuilder scale(String reference) {
        this.scale = Either.right((Object)reference);
        return this;
    }

    public MediumFramedEntityBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public MediumFramedEntityBuilder offsetY(String reference) {
        this.offsetY = Either.right((Object)reference);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("entity", this.resolve(this.entity, e -> (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)BuiltInRegistries.ENTITY_TYPE.getKey(e)).getOrThrow()));
        if (this.tag != null) {
            json.add("tag", this.resolve(this.tag, t -> (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)ops, t).getOrThrow()));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
    }
}

