/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.providers;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.favouriteless.modopedia.api.datagen.BookOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public abstract class TemplateProvider
implements DataProvider {
    private final String modId;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected TemplateProvider(String modId, CompletableFuture<HolderLookup.Provider> registries, PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "modopedia/templates");
        this.registries = registries;
        this.modId = modId;
    }

    protected abstract void build(HolderLookup.Provider var1, BookOutput var2);

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        HashSet set = Sets.newHashSet();
        ArrayList generated = new ArrayList();
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries);
        this.build(registries, (id, builder) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate " + this.getName() + ": " + id);
            }
            generated.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)builder.build((RegistryOps<JsonElement>)ops), (Path)this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id))));
        });
        return CompletableFuture.allOf((CompletableFuture[])generated.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Modopedia Templates[" + this.modId + "]";
    }
}

